/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp.message;

import java.util.HashSet;
import java.util.Set;
import org.apache.qpid.jms.JmsDestination;
import org.apache.qpid.jms.JmsQueue;
import org.apache.qpid.jms.JmsTemporaryQueue;
import org.apache.qpid.jms.JmsTemporaryTopic;
import org.apache.qpid.jms.JmsTopic;
import org.apache.qpid.jms.provider.amqp.AmqpConnection;
import org.apache.qpid.jms.provider.amqp.message.AmqpJmsMessageFacade;
import org.apache.qpid.jms.provider.amqp.message.AmqpMessageSupport;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.MessageAnnotations;

public class AmqpDestinationHelper {
    public static final Symbol JMS_DEST_TYPE_MSG_ANNOTATION_SYMBOL = Symbol.valueOf((String)"x-opt-jms-dest");
    public static final Symbol JMS_REPLY_TO_TYPE_MSG_ANNOTATION_SYMBOL = Symbol.valueOf((String)"x-opt-jms-reply-to");
    public static final byte QUEUE_TYPE = 0;
    public static final byte TOPIC_TYPE = 1;
    public static final byte TEMP_QUEUE_TYPE = 2;
    public static final byte TEMP_TOPIC_TYPE = 3;
    public static final Symbol QUEUE_CAPABILITY = Symbol.valueOf((String)"queue");
    public static final Symbol TOPIC_CAPABILITY = Symbol.valueOf((String)"topic");
    public static final Symbol TEMP_QUEUE_CAPABILITY = Symbol.valueOf((String)"temporary-queue");
    public static final Symbol TEMP_TOPIC_CAPABILITY = Symbol.valueOf((String)"temporary-topic");
    public static final byte UNKNOWN_TYPE = -1;

    public static JmsDestination getJmsDestination(AmqpJmsMessageFacade message, JmsDestination consumerDestination) {
        String to = message.getToAddress();
        byte typeByte = AmqpDestinationHelper.getTypeByte(message, JMS_DEST_TYPE_MSG_ANNOTATION_SYMBOL);
        if (typeByte == -1) {
            typeByte = AmqpDestinationHelper.getTypeByte(message, AmqpMessageSupport.LEGACY_TO_TYPE_MSG_ANNOTATION_SYMBOL);
        }
        String name = AmqpDestinationHelper.stripPrefixIfNecessary(to, message.getConnection(), typeByte, consumerDestination);
        return AmqpDestinationHelper.createDestination(name, typeByte, consumerDestination, false);
    }

    public static JmsDestination getJmsReplyTo(AmqpJmsMessageFacade message, JmsDestination consumerDestination) {
        String replyTo = message.getReplyToAddress();
        byte typeByte = AmqpDestinationHelper.getTypeByte(message, JMS_REPLY_TO_TYPE_MSG_ANNOTATION_SYMBOL);
        if (typeByte == -1) {
            typeByte = AmqpDestinationHelper.getTypeByte(message, AmqpMessageSupport.LEGACY_REPLY_TO_TYPE_MSG_ANNOTATION_SYMBOL);
        }
        String name = AmqpDestinationHelper.stripPrefixIfNecessary(replyTo, message.getConnection(), typeByte, consumerDestination);
        return AmqpDestinationHelper.createDestination(name, typeByte, consumerDestination, true);
    }

    private static String stripPrefixIfNecessary(String address, AmqpConnection conn, byte typeByte, JmsDestination consumerDestination) {
        String topicPrefix;
        if (address == null) {
            return null;
        }
        if (typeByte == -1) {
            String queuePrefix = conn.getQueuePrefix();
            if (queuePrefix != null && address.startsWith(queuePrefix)) {
                return address.substring(queuePrefix.length());
            }
            String topicPrefix2 = conn.getTopicPrefix();
            if (topicPrefix2 != null && address.startsWith(topicPrefix2)) {
                return address.substring(topicPrefix2.length());
            }
        } else if (typeByte == 0) {
            String queuePrefix = conn.getQueuePrefix();
            if (queuePrefix != null && address.startsWith(queuePrefix)) {
                return address.substring(queuePrefix.length());
            }
        } else if (typeByte == 1 && (topicPrefix = conn.getTopicPrefix()) != null && address.startsWith(topicPrefix)) {
            return address.substring(topicPrefix.length());
        }
        return address;
    }

    private static JmsDestination createDestination(String address, byte typeByte, JmsDestination consumerDestination, boolean useConsumerDestForTypeOnly) {
        if (address == null) {
            return useConsumerDestForTypeOnly ? null : consumerDestination;
        }
        if (typeByte != -1) {
            switch (typeByte) {
                case 0: {
                    return new JmsQueue(address);
                }
                case 1: {
                    return new JmsTopic(address);
                }
                case 2: {
                    return new JmsTemporaryQueue(address);
                }
                case 3: {
                    return new JmsTemporaryTopic(address);
                }
            }
        }
        if (consumerDestination.isQueue()) {
            if (consumerDestination.isTemporary()) {
                return new JmsTemporaryQueue(address);
            }
            return new JmsQueue(address);
        }
        if (consumerDestination.isTopic()) {
            if (consumerDestination.isTemporary()) {
                return new JmsTemporaryTopic(address);
            }
            return new JmsTopic(address);
        }
        return new JmsQueue(address);
    }

    public static void setToAddressFromDestination(AmqpJmsMessageFacade message, JmsDestination destination) {
        message.setToAddress(AmqpDestinationHelper.getDestinationAddress(destination, message.getConnection()));
        message.removeMessageAnnotation(JMS_DEST_TYPE_MSG_ANNOTATION_SYMBOL);
        message.removeMessageAnnotation(AmqpMessageSupport.LEGACY_TO_TYPE_MSG_ANNOTATION_SYMBOL);
    }

    public static void setReplyToAddressFromDestination(AmqpJmsMessageFacade message, JmsDestination destination) {
        message.setReplyToAddress(AmqpDestinationHelper.getDestinationAddress(destination, message.getConnection()));
        message.removeMessageAnnotation(JMS_REPLY_TO_TYPE_MSG_ANNOTATION_SYMBOL);
        message.removeMessageAnnotation(AmqpMessageSupport.LEGACY_REPLY_TO_TYPE_MSG_ANNOTATION_SYMBOL);
    }

    public static void setToAnnotationFromDestination(JmsDestination destination, MessageAnnotations annotations) {
        byte typeValue = AmqpDestinationHelper.toTypeAnnotation(destination);
        if (destination == null || typeValue == -1) {
            annotations.getValue().remove(JMS_DEST_TYPE_MSG_ANNOTATION_SYMBOL);
        } else {
            annotations.getValue().put(JMS_DEST_TYPE_MSG_ANNOTATION_SYMBOL, typeValue);
        }
    }

    public static void setReplyToAnnotationFromDestination(JmsDestination destination, MessageAnnotations annotations) {
        byte typeValue = AmqpDestinationHelper.toTypeAnnotation(destination);
        if (destination == null || typeValue == -1) {
            annotations.getValue().remove(JMS_REPLY_TO_TYPE_MSG_ANNOTATION_SYMBOL);
        } else {
            annotations.getValue().put(JMS_REPLY_TO_TYPE_MSG_ANNOTATION_SYMBOL, typeValue);
        }
    }

    public static String getDestinationAddress(JmsDestination destination, AmqpConnection connection) {
        if (destination == null) {
            return null;
        }
        String name = destination.getAddress();
        if (!destination.isTemporary()) {
            String topicPrefix;
            String queuePrefix;
            if (destination.isQueue() && (queuePrefix = connection.getQueuePrefix()) != null && !name.startsWith(queuePrefix)) {
                return queuePrefix + name;
            }
            if (destination.isTopic() && (topicPrefix = connection.getTopicPrefix()) != null && !name.startsWith(topicPrefix)) {
                return topicPrefix + name;
            }
        }
        return name;
    }

    static byte toTypeAnnotation(JmsDestination destination) {
        if (destination == null) {
            return -1;
        }
        if (destination.isQueue()) {
            if (destination.isTemporary()) {
                return 2;
            }
            return 0;
        }
        if (destination.isTopic()) {
            if (destination.isTemporary()) {
                return 3;
            }
            return 1;
        }
        return -1;
    }

    static Set<String> splitAttributesString(String typeString) {
        if (typeString == null) {
            return null;
        }
        HashSet<String> typeSet = new HashSet<String>();
        for (String attr : typeString.split("\\s*,\\s*")) {
            if (attr.equals("")) continue;
            typeSet.add(attr);
        }
        return typeSet;
    }

    static byte getTypeByte(AmqpJmsMessageFacade message, Symbol annotationName) {
        Object typeAnnotation = message.getMessageAnnotation(annotationName);
        if (typeAnnotation == null) {
            return -1;
        }
        if (typeAnnotation instanceof Byte) {
            return (Byte)typeAnnotation;
        }
        String typeString = String.valueOf(typeAnnotation);
        Set<String> typeSet = null;
        if (typeString != null) {
            typeSet = AmqpDestinationHelper.splitAttributesString(typeString);
        }
        if (typeSet != null && !typeSet.isEmpty()) {
            if (typeSet.contains("queue")) {
                if (typeSet.contains("temporary")) {
                    return 2;
                }
                return 0;
            }
            if (typeSet.contains("topic")) {
                if (typeSet.contains("temporary")) {
                    return 3;
                }
                return 1;
            }
        }
        return -1;
    }

    public static Symbol toTypeCapability(JmsDestination destination) {
        if (destination == null) {
            return null;
        }
        if (destination.isQueue()) {
            if (destination.isTemporary()) {
                return TEMP_QUEUE_CAPABILITY;
            }
            return QUEUE_CAPABILITY;
        }
        if (destination.isTopic()) {
            if (destination.isTemporary()) {
                return TEMP_TOPIC_CAPABILITY;
            }
            return TOPIC_CAPABILITY;
        }
        return null;
    }
}

