/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io.content;

import java.io.EOFException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.util.thread.Invocable;

public abstract class ContentSourceCompletableFuture<X>
extends CompletableFuture<X>
implements Invocable.Task {
    private final Content.Source _content;
    private final Invocable.InvocationType _invocationType;

    public ContentSourceCompletableFuture(Content.Source content) {
        this(content, Invocable.InvocationType.NON_BLOCKING);
    }

    public ContentSourceCompletableFuture(Content.Source content, Invocable.InvocationType invocationType) {
        this._invocationType = Objects.requireNonNull(invocationType);
        if (this._invocationType == Invocable.InvocationType.EITHER) {
            throw new IllegalArgumentException("EITHER is not supported");
        }
        this._content = content;
    }

    public void parse() {
        while (true) {
            Content.Chunk chunk;
            if ((chunk = this._content.read()) == null) {
                this._content.demand((Runnable)((Object)this));
                return;
            }
            if (Content.Chunk.isFailure(chunk)) {
                if (chunk.isLast()) {
                    this.completeExceptionally(chunk.getFailure());
                } else {
                    if (this.onTransientFailure(chunk.getFailure())) continue;
                    this._content.fail(chunk.getFailure());
                    this.completeExceptionally(chunk.getFailure());
                }
                return;
            }
            try {
                X x = this.parse(chunk);
                if (x != null) {
                    this.complete(x);
                    return;
                }
            }
            catch (Throwable failure) {
                this.completeExceptionally(failure);
                return;
            }
            finally {
                chunk.release();
            }
            if (chunk.isLast()) break;
        }
        this.completeExceptionally(new EOFException());
    }

    protected abstract X parse(Content.Chunk var1) throws Throwable;

    protected boolean onTransientFailure(Throwable cause) {
        return false;
    }

    public void run() {
        this.parse();
    }

    @Override
    public CompletableFuture<Void> acceptEither(CompletionStage<? extends X> other, Consumer<? super X> action) {
        if (!this.isDone() && this.getInvocationType() != Invocable.combineTypes((Invocable.InvocationType[])new Invocable.InvocationType[]{this.getInvocationType(), Invocable.getInvocationType(other), Invocable.getInvocationType(action)})) {
            throw new IllegalStateException("Bad invocation type when not completed");
        }
        return super.acceptEither(other, action);
    }

    @Override
    public <U> CompletableFuture<U> applyToEither(CompletionStage<? extends X> other, Function<? super X, U> fn) {
        if (!this.isDone() && this.getInvocationType() != Invocable.combineTypes((Invocable.InvocationType[])new Invocable.InvocationType[]{this.getInvocationType(), Invocable.getInvocationType(other), Invocable.getInvocationType(fn)})) {
            throw new IllegalStateException("Bad invocation type when not completed");
        }
        return super.applyToEither(other, fn);
    }

    @Override
    public X get() throws InterruptedException, ExecutionException {
        if (this.getInvocationType() == Invocable.InvocationType.BLOCKING && !this.isDone()) {
            throw new IllegalStateException("Must be NON_BLOCKING or completed");
        }
        return (X)super.get();
    }

    @Override
    public X get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.getInvocationType() == Invocable.InvocationType.BLOCKING && !this.isDone()) {
            throw new IllegalStateException("Must be NON_BLOCKING or completed");
        }
        return (X)super.get(timeout, unit);
    }

    public Invocable.InvocationType getInvocationType() {
        return this._invocationType;
    }

    @Override
    public <U> CompletableFuture<U> handle(BiFunction<? super X, Throwable, ? extends U> fn) {
        if (!this.isDone() && this.getInvocationType() != Invocable.combine((Invocable.InvocationType)this.getInvocationType(), (Invocable.InvocationType)Invocable.getInvocationType(fn))) {
            throw new IllegalStateException("Bad invocation type when not completed");
        }
        return super.handle(fn);
    }

    @Override
    public X join() {
        if (!this.isDone() && this.getInvocationType() == Invocable.InvocationType.BLOCKING && !this.isDone()) {
            throw new IllegalStateException("Must be NON_BLOCKING or completed");
        }
        return (X)super.join();
    }

    @Override
    public CompletableFuture<Void> runAfterBoth(CompletionStage<?> other, Runnable action) {
        if (!this.isDone() && this.getInvocationType() != Invocable.combine((Invocable.InvocationType)this.getInvocationType(), (Invocable.InvocationType)Invocable.getInvocationType((Object)action))) {
            throw new IllegalStateException("Bad invocation type when not completed");
        }
        return super.runAfterBoth((CompletionStage)other, action);
    }

    @Override
    public CompletableFuture<Void> runAfterEither(CompletionStage<?> other, Runnable action) {
        if (!this.isDone() && this.getInvocationType() != Invocable.combineTypes((Invocable.InvocationType[])new Invocable.InvocationType[]{this.getInvocationType(), Invocable.getInvocationType(other), Invocable.getInvocationType((Object)action)})) {
            throw new IllegalStateException("Bad invocation type when not completed");
        }
        return super.runAfterEither((CompletionStage)other, action);
    }

    @Override
    public CompletableFuture<Void> thenAccept(Consumer<? super X> action) {
        if (!this.isDone() && this.getInvocationType() != Invocable.combine((Invocable.InvocationType)this.getInvocationType(), (Invocable.InvocationType)Invocable.getInvocationType(action))) {
            throw new IllegalStateException("Bad invocation type when not completed");
        }
        return super.thenAccept(action);
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBoth(CompletionStage<? extends U> other, BiConsumer<? super X, ? super U> action) {
        if (!this.isDone() && this.getInvocationType() != Invocable.combineTypes((Invocable.InvocationType[])new Invocable.InvocationType[]{this.getInvocationType(), Invocable.getInvocationType(other), Invocable.getInvocationType(action)})) {
            throw new IllegalStateException("Bad invocation type when not completed");
        }
        return super.thenAcceptBoth((CompletionStage)other, action);
    }

    @Override
    public <U> CompletableFuture<U> thenApply(Function<? super X, ? extends U> fn) {
        if (!this.isDone() && this.getInvocationType() != Invocable.combine((Invocable.InvocationType)this.getInvocationType(), (Invocable.InvocationType)Invocable.getInvocationType(fn))) {
            throw new IllegalStateException("Bad invocation type when not completed");
        }
        return super.thenApply(fn);
    }

    @Override
    public <U, V1> CompletableFuture<V1> thenCombine(CompletionStage<? extends U> other, BiFunction<? super X, ? super U, ? extends V1> fn) {
        if (!this.isDone() && this.getInvocationType() != Invocable.combineTypes((Invocable.InvocationType[])new Invocable.InvocationType[]{this.getInvocationType(), Invocable.getInvocationType(other), Invocable.getInvocationType(fn)})) {
            throw new IllegalStateException("Bad invocation type when not completed");
        }
        return super.thenCombine((CompletionStage)other, fn);
    }

    @Override
    public <U> CompletableFuture<U> thenCompose(Function<? super X, ? extends CompletionStage<U>> fn) {
        if (!this.isDone() && this.getInvocationType() != Invocable.combine((Invocable.InvocationType)this.getInvocationType(), (Invocable.InvocationType)Invocable.getInvocationType(fn))) {
            throw new IllegalStateException("Bad invocation type when not completed");
        }
        return super.thenCompose(fn);
    }

    @Override
    public CompletableFuture<Void> thenRun(Runnable action) {
        if (!this.isDone() && this.getInvocationType() != Invocable.combine((Invocable.InvocationType)this.getInvocationType(), (Invocable.InvocationType)Invocable.getInvocationType((Object)action))) {
            throw new IllegalStateException("Bad invocation type when not completed");
        }
        return super.thenRun(action);
    }

    @Override
    public CompletableFuture<X> whenComplete(BiConsumer<? super X, ? super Throwable> action) {
        if (!this.isDone() && this.getInvocationType() != Invocable.combine((Invocable.InvocationType)this.getInvocationType(), (Invocable.InvocationType)Invocable.getInvocationType(action))) {
            throw new IllegalStateException("Bad invocation type when not completed");
        }
        return super.whenComplete(action);
    }
}

