/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.client.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Objects;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.TopologyMember;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.utils.ConfigurationHelper;

public final class TopologyMemberImpl
implements TopologyMember {
    private final Pair<TransportConfiguration, TransportConfiguration> connector;
    private final String backupGroupName;
    private final String scaleDownGroupName;
    private transient long uniqueEventID = System.currentTimeMillis();
    private final String nodeId;

    public TopologyMemberImpl(String nodeId, String backupGroupName, String scaleDownGroupName, TransportConfiguration a, TransportConfiguration b) {
        this.nodeId = nodeId;
        this.backupGroupName = backupGroupName;
        this.scaleDownGroupName = scaleDownGroupName;
        this.connector = new Pair((Object)a, (Object)b);
        this.uniqueEventID = System.currentTimeMillis();
    }

    @Override
    @Deprecated(forRemoval=true)
    public TransportConfiguration getLive() {
        return this.getPrimary();
    }

    @Override
    public TransportConfiguration getPrimary() {
        return (TransportConfiguration)this.connector.getA();
    }

    @Override
    public TransportConfiguration getBackup() {
        return (TransportConfiguration)this.connector.getB();
    }

    public void setBackup(TransportConfiguration param) {
        this.connector.setB((Object)param);
    }

    public void setPrimary(TransportConfiguration param) {
        this.connector.setA((Object)param);
    }

    @Override
    public String getNodeId() {
        return this.nodeId;
    }

    @Override
    public long getUniqueEventID() {
        return this.uniqueEventID;
    }

    @Override
    public String getBackupGroupName() {
        return this.backupGroupName;
    }

    @Override
    public String getScaleDownGroupName() {
        return this.scaleDownGroupName;
    }

    public void setUniqueEventID(long uniqueEventID) {
        this.uniqueEventID = uniqueEventID;
    }

    public Pair<TransportConfiguration, TransportConfiguration> getConnector() {
        return this.connector;
    }

    @Override
    public boolean isMember(RemotingConnection connection) {
        return connection.isSameTarget((TransportConfiguration)this.getConnector().getA(), (TransportConfiguration)this.getConnector().getB());
    }

    @Override
    public boolean isMember(TransportConfiguration configuration) {
        return this.getConnector().getA() != null && ((TransportConfiguration)this.getConnector().getA()).isSameParams(configuration) || this.getConnector().getB() != null && ((TransportConfiguration)this.getConnector().getB()).isSameParams(configuration);
    }

    @Override
    public String toURI() {
        TransportConfiguration primaryConnector = this.getPrimary();
        Map<String, Object> props = primaryConnector.getParams();
        String host = ConfigurationHelper.getStringProperty("host", "localhost", props);
        int port = ConfigurationHelper.getIntProperty("port", 0, props);
        return "tcp://" + host + ":" + port;
    }

    public URI toBackupURI() {
        TransportConfiguration backupConnector = this.getBackup();
        if (backupConnector == null) {
            return null;
        }
        Map<String, Object> props = backupConnector.getParams();
        String host = ConfigurationHelper.getStringProperty("host", "localhost", props);
        int port = ConfigurationHelper.getIntProperty("port", 0, props);
        boolean sslEnabled = ConfigurationHelper.getBooleanProperty("sslEnabled", false, props);
        try {
            return new URI("tcp://" + host + ":" + port + "?sslEnabled=" + sslEnabled);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public String toString() {
        return "TopologyMember[id=" + this.nodeId + ", connector=" + String.valueOf(this.connector) + ", backupGroupName=" + this.backupGroupName + ", scaleDownGroupName=" + this.scaleDownGroupName + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TopologyMemberImpl)) {
            return false;
        }
        TopologyMemberImpl other = (TopologyMemberImpl)obj;
        return Objects.equals(this.connector, other.connector) && Objects.equals(this.backupGroupName, other.backupGroupName) && Objects.equals(this.scaleDownGroupName, other.scaleDownGroupName) && Objects.equals(this.nodeId, other.nodeId);
    }

    public int hashCode() {
        return Objects.hash(this.connector, this.backupGroupName, this.scaleDownGroupName, this.nodeId);
    }
}

