/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.filter.impl;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.Objects;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.FilterConstants;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.federation.address.FederatedAddress;
import org.apache.activemq.artemis.selector.filter.BooleanExpression;
import org.apache.activemq.artemis.selector.filter.FilterException;
import org.apache.activemq.artemis.selector.filter.Filterable;
import org.apache.activemq.artemis.selector.impl.SelectorParser;
import org.apache.activemq.artemis.utils.ByteUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterImpl
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final SimpleString sfilterString;
    private final BooleanExpression booleanExpression;

    public static Filter createFilter(String filterStr) throws ActiveMQException {
        return FilterImpl.createFilter(SimpleString.of((String)(filterStr == null ? null : filterStr.trim())));
    }

    public static Filter createFilter(SimpleString filterStr) throws ActiveMQException {
        BooleanExpression booleanExpression;
        if (filterStr == null || filterStr.isEmpty()) {
            return null;
        }
        try {
            booleanExpression = SelectorParser.parse((String)filterStr.toString());
        }
        catch (Throwable e) {
            ActiveMQServerLogger.LOGGER.invalidFilter(filterStr);
            logger.debug("Invalid filter", e);
            throw ActiveMQMessageBundle.BUNDLE.invalidFilter(filterStr, e);
        }
        return new FilterImpl(filterStr, booleanExpression);
    }

    private FilterImpl(SimpleString str, BooleanExpression expression) {
        this.sfilterString = str;
        this.booleanExpression = expression;
    }

    @Override
    public SimpleString getFilterString() {
        return this.sfilterString;
    }

    @Override
    public boolean match(Message message) {
        return this.match(new FilterableServerMessage(message));
    }

    @Override
    public boolean match(Map<String, String> map) {
        return this.match(new FilterableMap(map));
    }

    @Override
    public synchronized boolean match(Filterable filterable) {
        try {
            return this.booleanExpression.matches(filterable);
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.invalidFilter(this.sfilterString);
            logger.debug("Invalid filter", (Throwable)e);
            return false;
        }
    }

    public int hashCode() {
        return Objects.hashCode(this.sfilterString);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FilterImpl)) {
            return false;
        }
        FilterImpl other = (FilterImpl)obj;
        return Objects.equals(this.sfilterString, other.sfilterString);
    }

    public String toString() {
        return "FilterImpl [sfilterString=" + String.valueOf(this.sfilterString) + "]";
    }

    private static Object getHeaderFieldValue(Message msg, SimpleString fieldName) {
        if (FilterConstants.ACTIVEMQ_USERID.equals((Object)fieldName)) {
            if (msg.getUserID() == null) {
                String amqpNativeID = msg.getStringProperty("NATIVE_MESSAGE_ID");
                if (amqpNativeID != null) {
                    return SimpleString.of((String)amqpNativeID);
                }
                return null;
            }
            String userID = msg.getUserID().toString();
            if (userID.startsWith("ID:")) {
                return SimpleString.of((String)userID);
            }
            return SimpleString.of((String)("ID:" + String.valueOf(msg.getUserID())));
        }
        if (FilterConstants.ACTIVEMQ_PRIORITY.equals((Object)fieldName)) {
            return (int)msg.getPriority();
        }
        if (FilterConstants.ACTIVEMQ_TIMESTAMP.equals((Object)fieldName)) {
            return msg.getTimestamp();
        }
        if (FilterConstants.ACTIVEMQ_DURABLE.equals((Object)fieldName)) {
            return msg.isDurable() ? FilterConstants.DURABLE : FilterConstants.NON_DURABLE;
        }
        if (FilterConstants.ACTIVEMQ_EXPIRATION.equals((Object)fieldName)) {
            return msg.getExpiration();
        }
        if (FilterConstants.ACTIVEMQ_SIZE.equals((Object)fieldName)) {
            return msg.getEncodeSize();
        }
        if (FilterConstants.ACTIVEMQ_ADDRESS.equals((Object)fieldName)) {
            return msg.getAddress();
        }
        if (FilterConstants.ACTIVEMQ_GROUP_ID.equals((Object)fieldName)) {
            return msg.getGroupID();
        }
        return null;
    }

    private static class FilterableServerMessage
    implements Filterable {
        private final Message message;

        private FilterableServerMessage(Message message) {
            this.message = message;
        }

        public Object getProperty(SimpleString id) {
            Object result = null;
            if (id.startsWith(FilterConstants.ACTIVEMQ_PREFIX)) {
                result = FilterImpl.getHeaderFieldValue(this.message, id);
            }
            if (id.startsWith(FederatedAddress.HDR_HOPS)) {
                byte[] bytes = this.message.getExtraBytesProperty(FederatedAddress.HDR_HOPS);
                Object object = result = bytes == null ? null : Integer.valueOf(ByteUtil.bytesToInt((byte[])bytes));
            }
            if (result == null) {
                result = this.message.getObjectPropertyForFilter(id);
            }
            if (result != null && result.getClass() == SimpleString.class) {
                result = result.toString();
            }
            return result;
        }

        public <T> T getBodyAs(Class<T> type) throws FilterException {
            T body = null;
            if (!this.message.isLargeMessage() && type == String.class) {
                try {
                    body = type.cast(this.message.getStringBody());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return body;
        }

        public Object getLocalConnectionId() {
            return null;
        }
    }

    private static class FilterableMap
    implements Filterable {
        private final Map<String, String> map;

        private FilterableMap(Map<String, String> map) {
            this.map = map;
        }

        public <T> T getBodyAs(Class<T> type) throws FilterException {
            return null;
        }

        public Object getProperty(SimpleString name) {
            return this.map.get(name.toString());
        }

        public Object getLocalConnectionId() {
            return null;
        }
    }
}

