/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.remoting.impl.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.net.SocketAddress;
import java.util.List;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.utils.SocketAddressUtil;

public class HAProxyMessageEnforcer
extends ByteToMessageDecoder {
    final String acceptorName;

    HAProxyMessageEnforcer(String acceptorName) {
        this.acceptorName = acceptorName;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (in.readableBytes() < 4) {
            return;
        }
        ctx.pipeline().remove((ChannelHandler)this);
        if (!HAProxyMessageEnforcer.isProxyProtocol(in)) {
            ActiveMQServerLogger.LOGGER.proxyProtocolViolation(SocketAddressUtil.toString((SocketAddress)ctx.channel().remoteAddress()), this.acceptorName, true, "did not use");
            ctx.close();
        }
    }

    public static boolean isProxyProtocol(ByteBuf in) {
        short magic1 = in.getUnsignedByte(in.readerIndex());
        short magic2 = in.getUnsignedByte(in.readerIndex() + 1);
        short magic3 = in.getUnsignedByte(in.readerIndex() + 2);
        short magic4 = in.getUnsignedByte(in.readerIndex() + 3);
        return magic1 == 80 && magic2 == 82 && magic3 == 79 && magic4 == 88 || magic1 == 13 && magic2 == 10 && magic3 == 13 && magic4 == 10;
    }
}

