/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.util.introspect.support;

import io.hawt.util.Strings;
import io.hawt.util.introspect.ClassLoaderProvider;
import io.hawt.util.introspect.support.CacheValue;
import io.hawt.util.introspect.support.ClassResource;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.WeakHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassScanner {
    private static final Logger LOG = LoggerFactory.getLogger(ClassScanner.class);
    private static final String[] SKIP_CLASSES = new String[]{"org.apache.log4j.net.ZeroConfSupport"};
    private final ClassLoader[] classLoaders;
    private final WeakHashMap<String, CacheValue> cache = new WeakHashMap();
    private final WeakHashMap<Package, CacheValue> packageCache = new WeakHashMap();
    private final Map<String, ClassLoaderProvider> classLoaderProviderMap = new HashMap<String, ClassLoaderProvider>();
    private Set<String> ignorePackages = new HashSet<String>(Collections.singletonList("sun.reflect.misc"));

    public static ClassScanner newInstance() {
        return new ClassScanner(Thread.currentThread().getContextClassLoader(), ClassScanner.class.getClassLoader());
    }

    public ClassScanner(ClassLoader ... classLoaders) {
        this.classLoaders = classLoaders;
    }

    public void clearCache() {
        this.cache.clear();
        this.packageCache.clear();
        this.classLoaderProviderMap.clear();
    }

    public void setClassLoaderProvider(String id, ClassLoaderProvider classLoaderProvider) {
        if (classLoaderProvider != null) {
            this.classLoaderProviderMap.put(id, classLoaderProvider);
        } else {
            this.classLoaderProviderMap.remove(id);
        }
    }

    protected void addPackageResources(Package aPackage, Map<String, ClassResource> urlSet, ClassLoader[] classLoaders) {
        String packageName = aPackage.getName();
        String relativePath = this.getPackageRelativePath(packageName);
        List<URL> resources = this.getResources(relativePath, classLoaders);
        for (URL resource : resources) {
            String key = this.getJavaResourceKey(resource);
            urlSet.put(key, new ClassResource(packageName, resource));
        }
    }

    private CacheValue createPackageCacheValue(Package aPackage, ClassLoader[] classLoaders) {
        HashMap<String, ClassResource> urlSet = new HashMap<String, ClassResource>();
        this.addPackageResources(aPackage, urlSet, classLoaders);
        CacheValue answer = new CacheValue();
        SortedSet<String> classNames = answer.getClassNames();
        Set entries = urlSet.entrySet();
        for (Map.Entry entry : entries) {
            String key = (String)entry.getKey();
            ClassResource classResource = (ClassResource)entry.getValue();
            CacheValue cacheValue = this.cache.get(key);
            if (cacheValue == null) {
                cacheValue = this.createCacheValue(key, classResource);
                this.cache.put(key, cacheValue);
            }
            classNames.addAll(cacheValue.getClassNames());
        }
        return answer;
    }

    protected CacheValue createCacheValue(String key, ClassResource classResource) {
        CacheValue answer = new CacheValue();
        SortedSet<String> classNames = answer.getClassNames();
        String packageName = classResource.getPackageName();
        URL resource = classResource.getResource();
        if (resource != null) {
            String resourceText = resource.toString();
            LOG.debug("Searching resource " + String.valueOf(resource));
            if (resourceText.startsWith("jar:")) {
                this.processJarClassNames(classResource, classNames);
            } else {
                this.processDirectoryClassNames(new File(resource.getPath()), packageName, classNames);
            }
        }
        return answer;
    }

    protected void processDirectoryClassNames(File directory, String packageName, Set<String> classes) {
        String[] fileNames = directory.list();
        if (fileNames != null) {
            for (String fileName : fileNames) {
                File subdir;
                Object packagePrefix;
                Object object = packagePrefix = Strings.isNotBlank(packageName) ? packageName + "." : packageName;
                if (fileName.endsWith(".class")) {
                    String className = (String)packagePrefix + fileName.substring(0, fileName.length() - 6);
                    classes.add(className);
                }
                if (!(subdir = new File(directory, fileName)).isDirectory()) continue;
                this.processDirectoryClassNames(subdir, (String)packagePrefix + fileName, classes);
            }
        }
    }

    protected void processJarClassNames(ClassResource classResource, Set<String> classes) {
        JarFile jarFile;
        URL resource = classResource.getResource();
        String packageName = classResource.getPackageName();
        String relativePath = this.getPackageRelativePath(packageName);
        String jarPath = this.getJarPath(resource);
        try {
            jarFile = new JarFile(jarPath);
        }
        catch (IOException e) {
            LOG.debug("IOException reading JAR '" + jarPath + ". Reason: " + String.valueOf(e), (Throwable)e);
            return;
        }
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String entryName = entry.getName();
            if (!entryName.endsWith(".class") || !entryName.startsWith(relativePath) || entryName.length() <= relativePath.length() + 1) continue;
            String className = entryName.replace('/', '.').replace('\\', '.').replace(".class", "");
            classes.add(className);
        }
        try {
            jarFile.close();
        }
        catch (IOException e) {
            LOG.debug("IOException closing JAR '" + jarPath + "'. Reason: " + String.valueOf(e), (Throwable)e);
        }
    }

    protected String getJavaResourceKey(URL resource) {
        String resourceText = resource.toString();
        if (resourceText.startsWith("jar:")) {
            return "jar:" + this.getJarPath(resource);
        }
        return resource.getPath();
    }

    private String getJarPath(URL resource) {
        String resourcePath = resource.getPath();
        return resourcePath.replaceFirst("[.]jar[!].*", ".jar").replaceFirst("file:", "");
    }

    protected List<URL> getResources(String relPath, ClassLoader ... classLoaders) {
        ArrayList<URL> answer = new ArrayList<URL>();
        for (ClassLoader classLoader : classLoaders) {
            try {
                Enumeration<URL> resources = classLoader.getResources(relPath);
                while (resources.hasMoreElements()) {
                    URL url = resources.nextElement();
                    if (url == null) continue;
                    answer.add(url);
                }
            }
            catch (IOException e) {
                LOG.warn("Failed to load resources for path " + relPath + " from class loader " + String.valueOf(classLoader) + ". Reason:  " + String.valueOf(e), (Throwable)e);
            }
            if (!(classLoader instanceof URLClassLoader)) continue;
            URLClassLoader loader = (URLClassLoader)classLoader;
            answer.addAll(Arrays.asList(loader.getURLs()));
        }
        return answer;
    }

    protected boolean classNameMatches(String className, String search) {
        return className.contains(search);
    }

    protected String getPackageRelativePath(String packageName) {
        return packageName.replace('.', '/');
    }

    protected boolean withinLimit(Integer limit, Collection<?> collection) {
        if (limit == null) {
            return true;
        }
        int value = limit;
        return value <= 0 || value > collection.size();
    }

    public List<ClassLoader> getClassLoaders() {
        ArrayList<ClassLoader> answer = new ArrayList<ClassLoader>(Arrays.asList(this.classLoaders));
        Collection<ClassLoaderProvider> classLoaderProviders = this.classLoaderProviderMap.values();
        for (ClassLoaderProvider classLoaderProvider : classLoaderProviders) {
            ClassLoader classLoader = classLoaderProvider.getClassLoader();
            if (classLoader == null) continue;
            answer.add(classLoader);
        }
        return answer;
    }
}

