/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.proton;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.routing.RoutingHandler;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPConnectionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPRoutingContext;
import org.apache.activemq.artemis.protocol.amqp.proton.AmqpSupport;
import org.apache.activemq.artemis.utils.ConfigurationHelper;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.transport.ConnectionError;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.Connection;

public class AMQPRoutingHandler
extends RoutingHandler<AMQPRoutingContext> {
    public AMQPRoutingHandler(ActiveMQServer server) {
        super(server);
    }

    public boolean route(AMQPConnectionContext connectionContext, Connection protonConnection) throws Exception {
        return this.route(new AMQPRoutingContext(connectionContext, protonConnection));
    }

    protected void refuse(AMQPRoutingContext context) {
        ErrorCondition error = new ErrorCondition();
        error.setCondition(ConnectionError.CONNECTION_FORCED);
        switch (context.getResult().getStatus()) {
            case REFUSED_USE_ANOTHER: {
                error.setDescription(String.format("Connection router %s rejected this connection", context.getRouter()));
                break;
            }
            case REFUSED_UNAVAILABLE: {
                error.setDescription(String.format("Connection router %s is not ready", context.getRouter()));
            }
        }
        Connection protonConnection = context.getProtonConnection();
        protonConnection.setCondition(error);
        protonConnection.setProperties(Collections.singletonMap(AmqpSupport.CONNECTION_OPEN_FAILED, true));
    }

    protected void redirect(AMQPRoutingContext context) {
        String host = ConfigurationHelper.getStringProperty((String)"host", (String)"localhost", (Map)context.getTarget().getConnector().getParams());
        int port = ConfigurationHelper.getIntProperty((String)"port", (int)61616, (Map)context.getTarget().getConnector().getParams());
        ErrorCondition error = new ErrorCondition();
        error.setCondition(ConnectionError.REDIRECT);
        error.setDescription(String.format("Connection router %s redirected this connection to %s:%d", context.getRouter(), host, port));
        HashMap<Symbol, Object> info = new HashMap<Symbol, Object>();
        info.put(AmqpSupport.NETWORK_HOST, host);
        info.put(AmqpSupport.PORT, port);
        error.setInfo(info);
        Connection protonConnection = context.getProtonConnection();
        protonConnection.setCondition(error);
        protonConnection.setProperties(Collections.singletonMap(AmqpSupport.CONNECTION_OPEN_FAILED, true));
    }
}

