/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.MD5Digest;
import com.datastax.driver.core.PreparedStatement;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class PreparedStatementHelper {
    private static final MessageDigest cachedDigest;

    private static MD5Digest id(PreparedStatement statement) {
        return statement.getPreparedId().boundValuesMetadata.id;
    }

    public static void assertStable(PreparedStatement first, PreparedStatement subsequent) {
        if (!PreparedStatementHelper.id(first).equals((Object)PreparedStatementHelper.id(subsequent))) {
            throw new AssertionError((Object)String.format("Subsequent id (%s) is different from the first one (%s)", PreparedStatementHelper.id(first), PreparedStatementHelper.id(subsequent)));
        }
    }

    public static void assertHashWithoutKeyspace(PreparedStatement statement, String queryString, String ks) {
        MD5Digest returned = PreparedStatementHelper.id(statement);
        if (!returned.equals((Object)PreparedStatementHelper.hashWithoutKeyspace(queryString, ks))) {
            if (returned.equals((Object)PreparedStatementHelper.hashWithKeyspace(queryString, ks))) {
                throw new AssertionError((Object)String.format("Got hash with keyspace from the cluster: %s, should have gotten %s", returned, PreparedStatementHelper.hashWithoutKeyspace(queryString, ks)));
            }
            throw new AssertionError((Object)String.format("Got unrecognized hash: %s", returned));
        }
    }

    public static void assertHashWithKeyspace(PreparedStatement statement, String queryString, String ks) {
        MD5Digest returned = PreparedStatementHelper.id(statement);
        if (!returned.equals((Object)PreparedStatementHelper.hashWithKeyspace(queryString, ks))) {
            if (returned.equals((Object)PreparedStatementHelper.hashWithoutKeyspace(queryString, ks))) {
                throw new AssertionError((Object)String.format("Got hash without keyspace from the cluster: %s, should have gotten %s", returned, PreparedStatementHelper.hashWithKeyspace(queryString, ks)));
            }
            throw new AssertionError((Object)String.format("Got unrecognized hash: %s", returned));
        }
    }

    public static boolean equalsToHashWithKeyspace(byte[] digest, String queryString, String ks) {
        return MD5Digest.wrap((byte[])digest).equals((Object)PreparedStatementHelper.hashWithKeyspace(queryString, ks));
    }

    public static MD5Digest hashWithKeyspace(String queryString, String ks) {
        return PreparedStatementHelper.computeId(queryString, ks);
    }

    public static boolean equalsToHashWithoutKeyspace(byte[] digest, String queryString, String ks) {
        return MD5Digest.wrap((byte[])digest).equals((Object)PreparedStatementHelper.hashWithoutKeyspace(queryString, ks));
    }

    public static MD5Digest hashWithoutKeyspace(String queryString, String ks) {
        return PreparedStatementHelper.computeId(queryString, null);
    }

    private static MD5Digest computeId(String queryString, String keyspace) {
        return PreparedStatementHelper.compute((String)(keyspace == null ? queryString : keyspace + queryString));
    }

    public static MD5Digest compute(String toHash) {
        try {
            return PreparedStatementHelper.compute(toHash.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static synchronized MD5Digest compute(byte[] toHash) {
        cachedDigest.reset();
        return MD5Digest.wrap((byte[])cachedDigest.digest(toHash));
    }

    static {
        try {
            cachedDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }
}

