/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.functions.Arguments;
import org.apache.cassandra.cql3.functions.FunctionFactory;
import org.apache.cassandra.cql3.functions.FunctionName;
import org.apache.cassandra.cql3.functions.FunctionParameter;
import org.apache.cassandra.cql3.functions.NativeFunction;
import org.apache.cassandra.cql3.functions.NativeFunctions;
import org.apache.cassandra.cql3.functions.NativeScalarFunction;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.exceptions.FunctionExecutionException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.utils.JsonUtils;

public class FromJsonFct
extends NativeScalarFunction {
    private static final Map<AbstractType<?>, FromJsonFct> instances = new ConcurrentHashMap();

    public static FromJsonFct getInstance(FunctionName name, AbstractType<?> returnType) {
        FromJsonFct func = instances.get(returnType);
        if (func == null) {
            func = new FromJsonFct(name, returnType);
            instances.put(returnType, func);
        }
        return func;
    }

    private FromJsonFct(FunctionName name, AbstractType<?> returnType) {
        super(name.name, returnType, UTF8Type.instance);
    }

    @Override
    public ByteBuffer execute(Arguments arguments) {
        assert (arguments.size() == 1) : String.format("Unexpectedly got %d arguments for %s()", arguments.size(), this.name.name);
        if (arguments.containsNulls()) {
            return null;
        }
        String jsonArg = (String)arguments.get(0);
        try {
            Object object = JsonUtils.JSON_OBJECT_MAPPER.readValue(jsonArg, Object.class);
            if (object == null) {
                return null;
            }
            return this.returnType.fromJSONObject(object).bindAndGet(QueryOptions.forProtocolVersion(arguments.getProtocolVersion()));
        }
        catch (IOException exc) {
            throw FunctionExecutionException.create(this.name(), Collections.singletonList("text"), String.format("Could not decode JSON string '%s': %s", jsonArg, exc));
        }
        catch (MarshalException exc) {
            throw FunctionExecutionException.create(this, exc);
        }
    }

    public static void addFunctionsTo(NativeFunctions functions) {
        functions.add(new Factory("from_json"));
        functions.add(new Factory("fromjson"));
    }

    private static class Factory
    extends FunctionFactory {
        private Factory(String name) {
            super(name, FunctionParameter.fixed(CQL3Type.Native.TEXT));
        }

        @Override
        protected NativeFunction doGetOrCreateFunction(List<AbstractType<?>> argTypes, AbstractType<?> receiverType) {
            if (receiverType == null) {
                throw new InvalidRequestException(String.format("%s() cannot be used in the selection clause of a SELECT statement", this.name.name));
            }
            return FromJsonFct.getInstance(this.name, receiverType);
        }
    }
}

