/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.io.util.DataOutputPlus;

public class SizedInts {
    public static int nonZeroSize(long value) {
        if (value < 0L) {
            value ^= 0xFFFFFFFFFFFFFFFFL;
        }
        int lz = Long.numberOfLeadingZeros(value);
        return (64 - lz + 1 + 7) / 8;
    }

    public static int sizeAllowingZero(long value) {
        if (value == 0L) {
            return 0;
        }
        return SizedInts.nonZeroSize(value);
    }

    public static long read(ByteBuffer src, int startPos, int bytes) {
        switch (bytes) {
            case 0: {
                return 0L;
            }
            case 1: {
                return src.get(startPos);
            }
            case 2: {
                return src.getShort(startPos);
            }
            case 3: {
                long high = src.get(startPos);
                return high << 16 | (long)src.getShort(startPos + 1) & 0xFFFFL;
            }
            case 4: {
                return src.getInt(startPos);
            }
            case 5: {
                long high = src.get(startPos);
                return high << 32 | (long)src.getInt(startPos + 1) & 0xFFFFFFFFL;
            }
            case 6: {
                long high = src.getShort(startPos);
                return high << 32 | (long)src.getInt(startPos + 2) & 0xFFFFFFFFL;
            }
            case 7: {
                long high = src.get(startPos);
                high = high << 16 | (long)src.getShort(startPos + 1) & 0xFFFFL;
                return high << 32 | (long)src.getInt(startPos + 3) & 0xFFFFFFFFL;
            }
            case 8: {
                return src.getLong(startPos);
            }
        }
        throw new AssertionError();
    }

    public static long readUnsigned(ByteBuffer src, int startPos, int bytes) {
        if (bytes == 8) {
            return src.getLong(startPos);
        }
        return SizedInts.read(src, startPos, bytes) & (1L << bytes * 8) - 1L;
    }

    public static void write(DataOutputPlus dest, long value, int size) throws IOException {
        dest.writeMostSignificantBytes(value << (8 - size) * 8, size);
    }
}

