/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl2;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.JexlTestCase;
import org.apache.commons.jexl2.JexlThreadedArithmetic;
import org.apache.commons.jexl2.MapContext;
import org.apache.commons.jexl2.junit.Asserter;

public class ArithmeticTest
extends JexlTestCase {
    private Asserter asserter;

    public ArithmeticTest() {
        super(ArithmeticTest.createThreadedArithmeticEngine(true));
    }

    public void setUp() {
        this.asserter = new Asserter(this.JEXL);
    }

    public void testUndefinedVar() throws Exception {
        this.asserter.failExpression("objects[1].status", ".* undefined variable objects.*");
    }

    public void testLeftNullOperand() throws Exception {
        this.asserter.setVariable("left", null);
        this.asserter.setVariable("right", 8);
        this.asserter.failExpression("left + right", ".*null.*");
        this.asserter.failExpression("left - right", ".*null.*");
        this.asserter.failExpression("left * right", ".*null.*");
        this.asserter.failExpression("left / right", ".*null.*");
        this.asserter.failExpression("left % right", ".*null.*");
        this.asserter.failExpression("left & right", ".*null.*");
        this.asserter.failExpression("left | right", ".*null.*");
        this.asserter.failExpression("left ^ right", ".*null.*");
    }

    public void testRightNullOperand() throws Exception {
        this.asserter.setVariable("left", 9);
        this.asserter.setVariable("right", null);
        this.asserter.failExpression("left + right", ".*null.*");
        this.asserter.failExpression("left - right", ".*null.*");
        this.asserter.failExpression("left * right", ".*null.*");
        this.asserter.failExpression("left / right", ".*null.*");
        this.asserter.failExpression("left % right", ".*null.*");
        this.asserter.failExpression("left & right", ".*null.*");
        this.asserter.failExpression("left | right", ".*null.*");
        this.asserter.failExpression("left ^ right", ".*null.*");
    }

    public void testNullOperands() throws Exception {
        this.asserter.setVariable("left", null);
        this.asserter.setVariable("right", null);
        this.asserter.failExpression("left + right", ".*null.*");
        this.asserter.failExpression("left - right", ".*null.*");
        this.asserter.failExpression("left * right", ".*null.*");
        this.asserter.failExpression("left / right", ".*null.*");
        this.asserter.failExpression("left % right", ".*null.*");
        this.asserter.failExpression("left & right", ".*null.*");
        this.asserter.failExpression("left | right", ".*null.*");
        this.asserter.failExpression("left ^ right", ".*null.*");
    }

    public void testNullOperand() throws Exception {
        this.asserter.setVariable("right", null);
        this.asserter.failExpression("~right", ".*null.*");
        this.asserter.failExpression("-right", ".*arithmetic.*");
    }

    public void testBigDecimal() throws Exception {
        this.asserter.setVariable("left", new BigDecimal(2));
        this.asserter.setVariable("right", new BigDecimal(6));
        this.asserter.assertExpression("left + right", new BigDecimal(8));
        this.asserter.assertExpression("right - left", new BigDecimal(4));
        this.asserter.assertExpression("right * left", new BigDecimal(12));
        this.asserter.assertExpression("right / left", new BigDecimal(3));
        this.asserter.assertExpression("right % left", new BigDecimal(0));
    }

    public void testBigInteger() throws Exception {
        this.asserter.setVariable("left", new BigInteger("2"));
        this.asserter.setVariable("right", new BigInteger("6"));
        this.asserter.assertExpression("left + right", new BigInteger("8"));
        this.asserter.assertExpression("right - left", new BigInteger("4"));
        this.asserter.assertExpression("right * left", new BigInteger("12"));
        this.asserter.assertExpression("right / left", new BigInteger("3"));
        this.asserter.assertExpression("right % left", new BigInteger("0"));
    }

    public void testUnaryMinus() throws Exception {
        this.asserter.setVariable("aByte", new Byte(1));
        this.asserter.setVariable("aShort", new Short(2));
        this.asserter.setVariable("anInteger", new Integer(3));
        this.asserter.setVariable("aLong", new Long(4L));
        this.asserter.setVariable("aFloat", new Float(5.5));
        this.asserter.setVariable("aDouble", new Double(6.6));
        this.asserter.setVariable("aBigInteger", new BigInteger("7"));
        this.asserter.setVariable("aBigDecimal", new BigDecimal("8.8"));
        this.asserter.assertExpression("-3", new Integer("-3"));
        this.asserter.assertExpression("-3.0", new Float("-3.0"));
        this.asserter.assertExpression("-aByte", new Byte(-1));
        this.asserter.assertExpression("-aShort", new Short(-2));
        this.asserter.assertExpression("-anInteger", new Integer(-3));
        this.asserter.assertExpression("-aLong", new Long(-4L));
        this.asserter.assertExpression("-aFloat", new Float(-5.5));
        this.asserter.assertExpression("-aDouble", new Double(-6.6));
        this.asserter.assertExpression("-aBigInteger", new BigInteger("-7"));
        this.asserter.assertExpression("-aBigDecimal", new BigDecimal("-8.8"));
    }

    public void testCalculations() throws Exception {
        this.asserter.setVariable("foo", new Integer(2));
        this.asserter.assertExpression("foo + 2", new Integer(4));
        this.asserter.assertExpression("3 + 3", new Integer(6));
        this.asserter.assertExpression("3 + 3 + foo", new Integer(8));
        this.asserter.assertExpression("3 * 3", new Integer(9));
        this.asserter.assertExpression("3 * 3 + foo", new Integer(11));
        this.asserter.assertExpression("3 * 3 - foo", new Integer(7));
        this.asserter.assertExpression("(4 + 3) * 6", new Integer(42));
        this.asserter.assertExpression("(8 - 2) * 7", new Integer(42));
        this.asserter.assertExpression("3 * \"3.0\"", new Double(9.0));
        this.asserter.assertExpression("3 * 3.0", new Double(9.0));
        this.asserter.assertExpression("6 / 3", new Integer(2));
        this.asserter.assertExpression("6.4 / 3", new Double(2.1333333333333333));
        this.asserter.assertExpression("0 / 3", new Integer(0));
        this.asserter.assertExpression("3 / 0", new Double(0.0));
        this.asserter.assertExpression("4 % 3", new Integer(1));
        this.asserter.assertExpression("4.8 % 3", new Double(1.7999999999999998));
        this.asserter.setVariable("imanull", null);
        this.asserter.assertExpression("imanull + 2", new Integer(2));
        this.asserter.assertExpression("imanull + imanull", new Integer(0));
    }

    public void testCoercions() throws Exception {
        this.asserter.assertExpression("1", new Integer(1));
        this.asserter.setVariable("I2", new Integer(2));
        this.asserter.setVariable("L2", new Long(2L));
        this.asserter.setVariable("L3", new Long(3L));
        this.asserter.setVariable("B10", BigInteger.TEN);
        this.asserter.assertExpression("I2 + 2", new Integer(4));
        this.asserter.assertExpression("I2 * 2", new Integer(4));
        this.asserter.assertExpression("I2 - 2", new Integer(0));
        this.asserter.assertExpression("I2 / 2", new Integer(1));
        this.asserter.assertExpression("I2 * L2", new Long(4L));
        this.asserter.assertExpression("I2 / L2", new Long(1L));
        this.asserter.assertExpression("L2 + 3", new Long(5L));
        this.asserter.assertExpression("L2 + L3", new Long(5L));
        this.asserter.assertExpression("L2 / L2", new Long(1L));
        this.asserter.assertExpression("L2 / 2", new Long(1L));
        this.asserter.assertExpression("B10 / 10", BigInteger.ONE);
        this.asserter.assertExpression("B10 / I2", new BigInteger("5"));
        this.asserter.assertExpression("B10 / L2", new BigInteger("5"));
    }

    public void testRegexp() throws Exception {
        Object[] vars;
        this.asserter.setVariable("str", "abc456");
        this.asserter.assertExpression("str =~ '.*456'", Boolean.TRUE);
        this.asserter.assertExpression("str !~ 'ABC.*'", Boolean.TRUE);
        this.asserter.setVariable("match", "abc.*");
        this.asserter.setVariable("nomatch", ".*123");
        this.asserter.assertExpression("str =~ match", Boolean.TRUE);
        this.asserter.assertExpression("str !~ match", Boolean.FALSE);
        this.asserter.assertExpression("str !~ nomatch", Boolean.TRUE);
        this.asserter.assertExpression("str =~ nomatch", Boolean.FALSE);
        this.asserter.setVariable("match", Pattern.compile("abc.*"));
        this.asserter.setVariable("nomatch", Pattern.compile(".*123"));
        this.asserter.assertExpression("str =~ match", Boolean.TRUE);
        this.asserter.assertExpression("str !~ match", Boolean.FALSE);
        this.asserter.assertExpression("str !~ nomatch", Boolean.TRUE);
        this.asserter.assertExpression("str =~ nomatch", Boolean.FALSE);
        this.asserter.assertExpression("'a' =~ ['a','b','c','d','e','f']", Boolean.TRUE);
        this.asserter.assertExpression("'a' !~ ['a','b','c','d','e','f']", Boolean.FALSE);
        this.asserter.assertExpression("'z' =~ ['a','b','c','d','e','f']", Boolean.FALSE);
        this.asserter.assertExpression("'z' !~ ['a','b','c','d','e','f']", Boolean.TRUE);
        int[] ai = new int[]{2, 4, 42, 54};
        ArrayList<Integer> al = new ArrayList<Integer>();
        for (int i : ai) {
            al.add(i);
        }
        HashMap<Integer, String> am = new HashMap<Integer, String>();
        am.put(2, "two");
        am.put(4, "four");
        am.put(42, "forty-two");
        am.put(54, "fifty-four");
        MatchingContainer ad = new MatchingContainer(ai);
        Set as = ad.values;
        for (Object var : vars = new Object[]{ai, al, am, ad, as}) {
            this.asserter.setVariable("container", var);
            for (int x : ai) {
                this.asserter.setVariable("x", x);
                this.asserter.assertExpression("x =~ container", Boolean.TRUE);
            }
            this.asserter.setVariable("x", 169);
            this.asserter.assertExpression("x !~ container", Boolean.TRUE);
        }
    }

    public void testDivideByZero() throws Exception {
        HashMap<String, Number> vars = new HashMap<String, Number>();
        MapContext context = new MapContext(vars);
        vars.put("aByte", new Byte(1));
        vars.put("aShort", new Short(2));
        vars.put("aInteger", new Integer(3));
        vars.put("aLong", new Long(4L));
        vars.put("aFloat", new Float(5.5));
        vars.put("aDouble", new Double(6.6));
        vars.put("aBigInteger", new BigInteger("7"));
        vars.put("aBigDecimal", new BigDecimal("8.8"));
        vars.put("zByte", new Byte(0));
        vars.put("zShort", new Short(0));
        vars.put("zInteger", new Integer(0));
        vars.put("zLong", new Long(0L));
        vars.put("zFloat", new Float(0.0f));
        vars.put("zDouble", new Double(0.0));
        vars.put("zBigInteger", new BigInteger("0"));
        vars.put("zBigDecimal", new BigDecimal("0"));
        String[] tnames = new String[]{"Byte", "Short", "Integer", "Long", "Float", "Double", "BigInteger", "BigDecimal"};
        int PERMS = tnames.length * tnames.length;
        JexlEngine jexl = ArithmeticTest.createThreadedArithmeticEngine(true);
        jexl.setCache(128);
        jexl.setSilent(false);
        for (int s = 0; s < 2; ++s) {
            JexlThreadedArithmetic.setLenient((Boolean)(s == 0 ? 1 : 0));
            int zthrow = 0;
            int zeval = 0;
            for (String vname : tnames) {
                for (String zname : tnames) {
                    String expr = "a" + vname + " / " + "z" + zname;
                    try {
                        double zero;
                        Expression zexpr = jexl.createExpression(expr);
                        Object nan = zexpr.evaluate((JexlContext)context);
                        if (!(nan instanceof Number) || (zero = ((Number)nan).doubleValue()) != 0.0) continue;
                        ++zeval;
                    }
                    catch (Exception any) {
                        ++zthrow;
                    }
                }
            }
            if (!jexl.isLenient()) {
                ArithmeticTest.assertTrue((String)("All expressions should have thrown " + zthrow + "/" + PERMS), (zthrow == PERMS ? 1 : 0) != 0);
                continue;
            }
            ArithmeticTest.assertTrue((String)("All expressions should have zeroed " + zeval + "/" + PERMS), (zeval == PERMS ? 1 : 0) != 0);
        }
        ArithmeticTest.debuggerCheck(jexl);
    }

    public static class MatchingContainer {
        private final Set<Integer> values = new HashSet<Integer>();

        public MatchingContainer(int[] is) {
            for (int value : is) {
                this.values.add(value);
            }
        }

        public boolean contains(int value) {
            return this.values.contains(value);
        }
    }
}

