/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.discovery;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.engine.descriptor.ClassBasedTestDescriptor;
import org.junit.jupiter.engine.discovery.AbstractAnnotatedDescriptorWrapper;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.UnrecoverableExceptions;
import org.junit.platform.engine.TestDescriptor;

abstract class AbstractOrderingVisitor<PARENT extends TestDescriptor, CHILD extends TestDescriptor, WRAPPER extends AbstractAnnotatedDescriptorWrapper<?>>
implements TestDescriptor.Visitor {
    private static final Logger logger = LoggerFactory.getLogger(AbstractOrderingVisitor.class);

    AbstractOrderingVisitor() {
    }

    protected void doWithMatchingDescriptor(Class<PARENT> parentTestDescriptorType, TestDescriptor testDescriptor, Consumer<PARENT> action, Function<PARENT, String> errorMessageBuilder) {
        if (parentTestDescriptorType.isInstance(testDescriptor)) {
            TestDescriptor parentTestDescriptor = testDescriptor;
            try {
                action.accept(parentTestDescriptor);
            }
            catch (Throwable t) {
                UnrecoverableExceptions.rethrowIfUnrecoverable(t);
                logger.error(t, () -> (String)errorMessageBuilder.apply(parentTestDescriptor));
            }
        }
    }

    protected void orderChildrenTestDescriptors(TestDescriptor parentTestDescriptor, Class<CHILD> matchingChildrenType, Function<CHILD, WRAPPER> descriptorWrapperFactory, DescriptorWrapperOrderer descriptorWrapperOrderer) {
        Set<? extends TestDescriptor> children = parentTestDescriptor.getChildren();
        List matchingDescriptorWrappers = children.stream().filter(matchingChildrenType::isInstance).map(matchingChildrenType::cast).map(descriptorWrapperFactory).collect(Collectors.toCollection(ArrayList::new));
        if (matchingDescriptorWrappers.isEmpty()) {
            return;
        }
        if (descriptorWrapperOrderer.canOrderWrappers()) {
            List nonMatchingTestDescriptors = children.stream().filter(childTestDescriptor -> !matchingChildrenType.isInstance(childTestDescriptor)).collect(Collectors.toList());
            LinkedHashSet originalWrappers = new LinkedHashSet(matchingDescriptorWrappers);
            descriptorWrapperOrderer.orderWrappers(matchingDescriptorWrappers);
            int difference = matchingDescriptorWrappers.size() - originalWrappers.size();
            if (difference > 0) {
                descriptorWrapperOrderer.logDescriptorsAddedWarning(difference);
            } else if (difference < 0) {
                descriptorWrapperOrderer.logDescriptorsRemovedWarning(difference);
            }
            Set orderedTestDescriptors = matchingDescriptorWrappers.stream().filter(originalWrappers::contains).map(AbstractAnnotatedDescriptorWrapper::getTestDescriptor).collect(Collectors.toCollection(LinkedHashSet::new));
            Stream.concat(orderedTestDescriptors.stream(), nonMatchingTestDescriptors.stream()).forEach(parentTestDescriptor::removeChild);
            if (matchingChildrenType == ClassBasedTestDescriptor.class) {
                Stream.concat(nonMatchingTestDescriptors.stream(), orderedTestDescriptors.stream()).forEach(parentTestDescriptor::addChild);
            } else {
                Stream.concat(orderedTestDescriptors.stream(), nonMatchingTestDescriptors.stream()).forEach(parentTestDescriptor::addChild);
            }
        }
        matchingDescriptorWrappers.forEach(descriptorWrapper -> {
            TestDescriptor newParentTestDescriptor = descriptorWrapper.getTestDescriptor();
            DescriptorWrapperOrderer newDescriptorWrapperOrderer = this.getDescriptorWrapperOrderer(descriptorWrapperOrderer, (AbstractAnnotatedDescriptorWrapper<?>)descriptorWrapper);
            this.orderChildrenTestDescriptors(newParentTestDescriptor, matchingChildrenType, descriptorWrapperFactory, newDescriptorWrapperOrderer);
        });
    }

    protected DescriptorWrapperOrderer getDescriptorWrapperOrderer(DescriptorWrapperOrderer inheritedDescriptorWrapperOrderer, AbstractAnnotatedDescriptorWrapper<?> descriptorWrapper) {
        return inheritedDescriptorWrapperOrderer;
    }

    protected class DescriptorWrapperOrderer {
        private final Consumer<List<WRAPPER>> orderingAction;
        private final MessageGenerator descriptorsAddedMessageGenerator;
        private final MessageGenerator descriptorsRemovedMessageGenerator;

        DescriptorWrapperOrderer(Consumer<List<WRAPPER>> orderingAction, MessageGenerator descriptorsAddedMessageGenerator, MessageGenerator descriptorsRemovedMessageGenerator) {
            this.orderingAction = orderingAction;
            this.descriptorsAddedMessageGenerator = descriptorsAddedMessageGenerator;
            this.descriptorsRemovedMessageGenerator = descriptorsRemovedMessageGenerator;
        }

        private boolean canOrderWrappers() {
            return this.orderingAction != null;
        }

        private void orderWrappers(List<WRAPPER> wrappers) {
            this.orderingAction.accept(wrappers);
        }

        private void logDescriptorsAddedWarning(int number) {
            logger.warn(() -> this.descriptorsAddedMessageGenerator.generateMessage(number));
        }

        private void logDescriptorsRemovedWarning(int number) {
            logger.warn(() -> this.descriptorsRemovedMessageGenerator.generateMessage(Math.abs(number)));
        }
    }

    @FunctionalInterface
    protected static interface MessageGenerator {
        public String generateMessage(int var1);
    }
}

