/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.processors;

import java.io.Serializable;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.exceptions.ThrowsSDE;
import org.apache.daffodil.lib.iapi.WarnID$VariableSet$;
import org.apache.daffodil.lib.schema.annotation.props.gen.VariableDirection;
import org.apache.daffodil.lib.schema.annotation.props.gen.VariableDirection$Both$;
import org.apache.daffodil.lib.schema.annotation.props.gen.VariableDirection$ParseOnly$;
import org.apache.daffodil.lib.schema.annotation.props.gen.VariableDirection$UnparseOnly$;
import org.apache.daffodil.lib.util.Maybe$;
import org.apache.daffodil.lib.xml.GlobalQName;
import org.apache.daffodil.lib.xml.NS;
import org.apache.daffodil.lib.xml.RefQName;
import org.apache.daffodil.lib.xml.UnspecifiedNamespace$;
import org.apache.daffodil.runtime1.dpath.InvalidPrimitiveDataException;
import org.apache.daffodil.runtime1.dsom.CompiledExpression;
import org.apache.daffodil.runtime1.infoset.DataValue;
import org.apache.daffodil.runtime1.infoset.DataValue$;
import org.apache.daffodil.runtime1.processors.ExternalVariableException;
import org.apache.daffodil.runtime1.processors.ParseOrUnparseState;
import org.apache.daffodil.runtime1.processors.VariableBeingDefined$;
import org.apache.daffodil.runtime1.processors.VariableCircularDefinition;
import org.apache.daffodil.runtime1.processors.VariableDefined$;
import org.apache.daffodil.runtime1.processors.VariableHasNoValue;
import org.apache.daffodil.runtime1.processors.VariableInProcess$;
import org.apache.daffodil.runtime1.processors.VariableInstance;
import org.apache.daffodil.runtime1.processors.VariableMap$;
import org.apache.daffodil.runtime1.processors.VariableRead$;
import org.apache.daffodil.runtime1.processors.VariableRuntimeData;
import org.apache.daffodil.runtime1.processors.VariableSet$;
import org.apache.daffodil.runtime1.processors.VariableState;
import org.apache.daffodil.runtime1.processors.VariableSuspended;
import org.apache.daffodil.runtime1.processors.VariableUndefined$;
import org.apache.daffodil.runtime1.processors.parsers.PState;
import org.apache.daffodil.runtime1.processors.unparsers.UState;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class VariableMap
implements Serializable {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(VariableMap.class.getDeclaredField("context$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(VariableMap.class.getDeclaredField("qnames$lzy1"));
    private final Seq vrds;
    private final Seq<VariableInstance>[] vTable;
    private volatile Object qnames$lzy1;
    private volatile Object context$lzy1;

    public static VariableMap apply(Seq<VariableRuntimeData> seq) {
        return VariableMap$.MODULE$.apply(seq);
    }

    public static Seq<VariableRuntimeData> apply$default$1() {
        return VariableMap$.MODULE$.apply$default$1();
    }

    public VariableMap(Seq<VariableRuntimeData> vrds, Seq<VariableInstance>[] vTable) {
        this.vrds = vrds;
        this.vTable = vTable;
    }

    public Seq<VariableRuntimeData> vrds() {
        return this.vrds;
    }

    public String toString() {
        return "VariableMap(" + Predef$.MODULE$.wrapRefArray((Object[])this.vTable).mkString(" | ") + ")";
    }

    public VariableMap copy() {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.vTable);
        Seq[] table = (Seq[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)variableInstances -> {
            Seq newBuf = (Seq)variableInstances.map((Function1 & Serializable)_$6 -> _$6.copy(_$6.copy$default$1(), _$6.copy$default$2(), _$6.copy$default$3()));
            return newBuf;
        }, ClassTag$.MODULE$.apply(Seq.class));
        return new VariableMap(this.vrds(), table);
    }

    public VariableMap cloneForSuspension() {
        Seq[] newTable = new Seq[this.vTable.length];
        Array$.MODULE$.copy(this.vTable, 0, (Object)newTable, 0, this.vTable.length);
        return new VariableMap(this.vrds(), newTable);
    }

    public void forceExpressionEvaluations(ParseOrUnparseState state) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.vTable);
        ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)variableInstances -> {
            VariableInstance inst = (VariableInstance)variableInstances.head();
            if (inst.state() == VariableUndefined$.MODULE$ && Maybe$.MODULE$.isDefined$extension(inst.rd().maybeDefaultValueExpr())) {
                Object res = ((CompiledExpression)Maybe$.MODULE$.get$extension(inst.rd().maybeDefaultValueExpr())).evaluate(state);
                inst.setDefaultValue(DataValue$.MODULE$.unsafeFromAnyRef(res));
                return;
            }
        });
    }

    public void setFirstInstanceInitialValues() {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.vTable);
        ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)variableInstances -> ((VariableInstance)variableInstances.head()).firstInstanceInitialValue_$eq(((VariableInstance)variableInstances.head()).value()));
    }

    public Option<VariableInstance> find(RefQName qName) {
        return this.getVariableRuntimeData(qName).map((Function1 & Serializable)vrd -> (VariableInstance)this.vTable[vrd.vmapIndex()].head());
    }

    public Option<VariableInstance> find(GlobalQName qName) {
        return this.find(qName.toRefQName());
    }

    public Seq<GlobalQName> qnames() {
        Object object = this.qnames$lzy1;
        if (object instanceof Seq) {
            return (Seq)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Seq)this.qnames$lzyINIT1();
    }

    private Object qnames$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.qnames$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Seq seq = null;
                    try {
                        seq = (Seq)this.vrds().map((Function1 & Serializable)_$7 -> _$7.globalQName());
                        object2 = seq == null ? LazyVals.NullValue$.MODULE$ : seq;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.qnames$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return seq;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Option<VariableRuntimeData> getVariableRuntimeData(RefQName qName) {
        return this.vrds().find((Function1 & Serializable)_$8 -> _$8.globalQName().matches(qName));
    }

    public Nothing$ context() {
        Object object = this.context$lzy1;
        if (object instanceof Nothing$) {
            return (Nothing$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Nothing$)this.context$lzyINIT1();
    }

    private Object context$lzyINIT1() {
        Object object;
        block6: {
            while (true) {
                if ((object = this.context$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object var2_2 = null;
                    Object var3_3 = null;
                    try {
                        throw Assert$.MODULE$.invariantFailed("unused.");
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, var2_2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.context$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, var2_2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block6;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public boolean readVariableWillChangeState(VariableRuntimeData vrd) {
        Object object;
        VariableInstance variable = (VariableInstance)this.vTable[vrd.vmapIndex()].head();
        boolean variableRead = variable.state() == VariableRead$.MODULE$ && DataValue$.MODULE$.isDefined$extension(object = variable.value());
        return !variableRead;
    }

    public Object readVariable(VariableRuntimeData vrd, ThrowsSDE referringContext, ParseOrUnparseState state) {
        Object object;
        VariableRuntimeData varAtIndexVRD;
        GlobalQName varQName = vrd.globalQName();
        VariableDirection variableDirection = vrd.direction();
        if (VariableDirection$ParseOnly$.MODULE$.equals(variableDirection) && !(state instanceof PState)) {
            throw state.SDE(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Attempting to read variable %s which is marked as parseOnly during unparsing"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{varQName})), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        }
        if (VariableDirection$UnparseOnly$.MODULE$.equals(variableDirection) && !(state instanceof UState)) {
            throw state.SDE(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Attempting to read variable %s which is marked as unparseOnly during parsing"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{varQName})), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        }
        VariableInstance varAtIndex = (VariableInstance)this.vTable[vrd.vmapIndex()].head();
        VariableRuntimeData variableRuntimeData = varAtIndexVRD = varAtIndex.rd();
        VariableRuntimeData variableRuntimeData2 = vrd;
        if ((variableRuntimeData == null ? variableRuntimeData2 != null : !variableRuntimeData.equals(variableRuntimeData2)) && varAtIndexVRD != vrd && varAtIndexVRD.globalQName() != vrd.globalQName()) {
            throw Assert$.MODULE$.abort("Invariant broken: varAtIndexVRD.eq(vrd).||(varAtIndexVRD.globalQName.eq(vrd.globalQName))");
        }
        VariableInstance variable = varAtIndex;
        VariableState variableState = variable.state();
        if (VariableRead$.MODULE$.equals(variableState) && DataValue$.MODULE$.isDefined$extension(object = variable.value())) {
            Object object2 = variable.value();
            return new DataValue(DataValue$.MODULE$.getNonNullable$extension(object2)).v();
        }
        if (VariableDefined$.MODULE$.equals(variableState) || VariableSet$.MODULE$.equals(variableState)) {
            Object object3 = variable.value();
            if (DataValue$.MODULE$.isDefined$extension(object3)) {
                variable.setState(VariableRead$.MODULE$);
                Object object4 = variable.value();
                return new DataValue(DataValue$.MODULE$.getNonNullable$extension(object4)).v();
            }
        }
        if (VariableUndefined$.MODULE$.equals(variableState) && Maybe$.MODULE$.isDefined$extension(variable.rd().maybeDefaultValueExpr())) {
            variable.setState(VariableBeingDefined$.MODULE$);
            Object res = DataValue$.MODULE$.unsafeFromAnyRef(((CompiledExpression)Maybe$.MODULE$.get$extension(variable.rd().maybeDefaultValueExpr())).evaluate(state));
            variable.setState(VariableRead$.MODULE$);
            variable.setValue(res);
            return res;
        }
        if (VariableBeingDefined$.MODULE$.equals(variableState)) {
            throw new VariableCircularDefinition(varQName, vrd);
        }
        if (VariableInProcess$.MODULE$.equals(variableState)) {
            throw new VariableSuspended(varQName, vrd);
        }
        throw new VariableHasNoValue(varQName, vrd);
    }

    public void setVariable(VariableRuntimeData vrd, Object newValue, ThrowsSDE referringContext, ParseOrUnparseState pstate) {
        GlobalQName varQName = vrd.globalQName();
        Seq<VariableInstance> variableInstances = this.vTable[vrd.vmapIndex()];
        VariableInstance variable = (VariableInstance)variableInstances.head();
        VariableState variableState = variable.state();
        if (VariableSet$.MODULE$.equals(variableState)) {
            throw referringContext.SDE("Cannot set variable %s twice. State was: %s. Existing value: %s", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{variable.rd().globalQName(), VariableSet$.MODULE$, new DataValue(variable.value())}));
        }
        if (VariableRead$.MODULE$.equals(variableState)) {
            pstate.SDW(WarnID$VariableSet$.MODULE$, "Cannot set variable %s after reading the default value. State was: %s. Existing value: %s", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{variable.rd().globalQName(), VariableRead$.MODULE$, new DataValue(variable.value())}));
            variable.setValue(newValue);
            variable.setState(VariableSet$.MODULE$);
            return;
        }
        VariableDirection variableDirection = vrd.direction();
        if (VariableDirection$UnparseOnly$.MODULE$.equals(variableDirection) || VariableDirection$Both$.MODULE$.equals(variableDirection)) {
            if (Maybe$.MODULE$.isDefined$extension(vrd.maybeDefaultValueExpr()) && variableInstances.size() > 1) {
                throw pstate.SDE("Variable %s has an unparse direction and a default value, setting the variable may cause race conditions when combined with a forward referencing expression.", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{varQName}));
            }
        }
        variable.setValue(newValue);
        variable.setState(VariableSet$.MODULE$);
    }

    public VariableInstance newVariableInstance(VariableRuntimeData vrd) {
        Seq<VariableInstance> variableInstances = this.vTable[vrd.vmapIndex()];
        VariableInstance nvi = vrd.createVariableInstance();
        nvi.firstInstanceInitialValue_$eq(((VariableInstance)variableInstances.head()).firstInstanceInitialValue());
        this.vTable[vrd.vmapIndex()] = (Seq)variableInstances.$plus$colon((Object)nvi);
        return nvi;
    }

    public void removeVariableInstance(VariableRuntimeData vrd) {
        Seq<VariableInstance> variableInstances = this.vTable[vrd.vmapIndex()];
        if (!variableInstances.nonEmpty()) {
            throw Assert$.MODULE$.abort("Invariant broken: variableInstances.nonEmpty");
        }
        this.vTable[vrd.vmapIndex()] = (Seq)variableInstances.tail();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setExtVariable(RefQName bindingQName, String newValue, ThrowsSDE referringContext) {
        Object object;
        Option optVariableInstances;
        Option option;
        NS nS = bindingQName.namespace();
        UnspecifiedNamespace$ unspecifiedNamespace$ = UnspecifiedNamespace$.MODULE$;
        if (!(nS != null ? !((Object)nS).equals(unspecifiedNamespace$) : unspecifiedNamespace$ != null)) {
            Seq candidates = (Seq)this.vrds().filter((Function1 & Serializable)vrd -> {
                String string = vrd.globalQName().local();
                String string2 = bindingQName.local();
                return !(string != null ? !string.equals(string2) : string2 != null);
            });
            int n = candidates.size();
            if (0 == n) {
                option = None$.MODULE$;
            } else {
                if (1 != n) {
                    String msg = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("External variable binding %s is ambiguous. A namespace is required to resolve the ambiguity. Found variables: %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{bindingQName, ((IterableOnceOps)candidates.map((Function1 & Serializable)_$9 -> _$9.globalQName().toString())).mkString(", ")}));
                    throw new ExternalVariableException(msg);
                }
                option = Some$.MODULE$.apply(this.vTable[((VariableRuntimeData)candidates.head()).vmapIndex()]);
            }
        } else {
            Option optVrd = this.vrds().find((Function1 & Serializable)_$10 -> {
                GlobalQName globalQName = _$10.globalQName();
                GlobalQName globalQName2 = bindingQName.toGlobalQName();
                return !(globalQName != null ? !((Object)globalQName).equals(globalQName2) : globalQName2 != null);
            });
            option = optVrd.map((Function1 & Serializable)vrd -> this.vTable[vrd.vmapIndex()]);
        }
        Option option2 = optVariableInstances = option;
        if (None$.MODULE$.equals(option2)) {
            throw new ExternalVariableException("Variable definition not found: " + bindingQName);
        }
        if (!(option2 instanceof Some)) {
            throw new MatchError((Object)option2);
        }
        Seq variableInstances = (Seq)((Some)option2).value();
        if (variableInstances.size() != 1) {
            throw Assert$.MODULE$.abort("Invariant broken: variableInstances.size.==(1)");
        }
        VariableInstance variable = (VariableInstance)variableInstances.head();
        if (!variable.rd().external()) {
            throw new ExternalVariableException("Variable cannot be set externally: " + variable.rd().globalQName());
        }
        VariableState variableState = variable.state();
        if (!VariableDefined$.MODULE$.equals(variableState) && !VariableUndefined$.MODULE$.equals(variableState)) {
            throw Assert$.MODULE$.impossible(Assert$.MODULE$.impossible$default$1());
        }
        try {
            object = variable.rd().primType().fromXMLString(newValue);
        }
        catch (InvalidPrimitiveDataException e) {
            String msg = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Value for variable %s is not a valid %s: %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{variable.rd().globalQName(), variable.rd().primType().globalQName(), newValue}));
            throw new ExternalVariableException(msg);
        }
        Object value = object;
        variable.setValue(value);
        variable.setState(VariableDefined$.MODULE$);
    }
}

