/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.source.stream;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.generator.source.SourceElement;
import org.apache.torque.generator.source.SourceException;
import org.apache.torque.generator.source.SourceImpl;
import org.apache.torque.generator.source.stream.FileSource;
import org.apache.torque.generator.source.stream.SourceToXml;

public class CombinedFileSource
extends SourceImpl {
    public static final String ROOT_ELEMENT_NAME = "source";
    public static final String FILE_ELEMENT_NAME = "file";
    public static final String PATH_ATTRIBUTE_NAME = "path";
    private static Log log = LogFactory.getLog(CombinedFileSource.class);
    private final List<FileSource> fileSources;

    public CombinedFileSource(Collection<FileSource> fileSources) {
        if (fileSources == null) {
            throw new NullPointerException("path must not be null");
        }
        this.fileSources = new ArrayList<FileSource>(fileSources);
    }

    @Override
    public SourceElement createRootElement() throws SourceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"start creating root Element");
        }
        SourceElement result = new SourceElement(ROOT_ELEMENT_NAME);
        for (FileSource fileSource : this.fileSources) {
            SourceElement fileElement = new SourceElement(FILE_ELEMENT_NAME);
            fileElement.setAttribute(PATH_ATTRIBUTE_NAME, (Object)fileSource.getPath().getPath());
            fileElement.getChildren().add(fileSource.getRootElement());
            result.getChildren().add(fileElement);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("finished creating root Element, source is\n" + new SourceToXml().toXml(result, true)));
        }
        return result;
    }

    @Override
    public String getDescription() {
        StringBuilder result = new StringBuilder();
        for (FileSource fileSource : this.fileSources) {
            if (result.length() > 0) {
                result.append(';');
            }
            result.append(fileSource.getPath());
        }
        return result.toString();
    }

    @Override
    public File getSourceFile() {
        return null;
    }

    @Override
    public Date getLastModified() {
        Date result = null;
        for (FileSource fileSource : this.fileSources) {
            Date fileLastModified = fileSource.getLastModified();
            if (fileLastModified == null) {
                return null;
            }
            if (result != null && !fileLastModified.before(result)) continue;
            result = fileLastModified;
        }
        return result;
    }

    @Override
    public byte[] getContentChecksum() {
        byte[] result = new byte[]{};
        for (FileSource fileSource : this.fileSources) {
            byte[] fileChecksum = fileSource.getContentChecksum();
            if (fileChecksum == null) {
                return null;
            }
            byte[] lastResult = result;
            result = new byte[Math.max(lastResult.length, fileChecksum.length)];
            for (int i = 0; i < result.length; ++i) {
                result[i] = i < lastResult.length && i < fileChecksum.length ? (byte)(lastResult[i] + fileChecksum[i]) : (i < lastResult.length ? lastResult[i] : fileChecksum[i]);
            }
        }
        return result;
    }

    public String toString() {
        return this.getDescription();
    }
}

