/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import org.apache.commons.jcs.auxiliary.AbstractAuxiliaryCache;
import org.apache.commons.jcs.engine.behavior.ICacheElement;
import org.apache.commons.jcs.engine.logging.behavior.ICacheEvent;

public abstract class AbstractAuxiliaryCacheEventLogging<K, V>
extends AbstractAuxiliaryCache<K, V> {
    @Override
    public void update(ICacheElement<K, V> cacheElement) throws IOException {
        this.updateWithEventLogging(cacheElement);
    }

    protected final void updateWithEventLogging(ICacheElement<K, V> cacheElement) throws IOException {
        ICacheEvent<K> cacheEvent = this.createICacheEvent(cacheElement, "update");
        try {
            this.processUpdate(cacheElement);
        }
        finally {
            this.logICacheEvent(cacheEvent);
        }
    }

    protected abstract void processUpdate(ICacheElement<K, V> var1) throws IOException;

    @Override
    public ICacheElement<K, V> get(K key) throws IOException {
        return this.getWithEventLogging(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final ICacheElement<K, V> getWithEventLogging(K key) throws IOException {
        ICacheEvent<K> cacheEvent = this.createICacheEvent(this.getCacheName(), key, "get");
        try {
            ICacheElement<K, V> iCacheElement = this.processGet(key);
            return iCacheElement;
        }
        finally {
            this.logICacheEvent(cacheEvent);
        }
    }

    protected abstract ICacheElement<K, V> processGet(K var1) throws IOException;

    @Override
    public Map<K, ICacheElement<K, V>> getMultiple(Set<K> keys) throws IOException {
        return this.getMultipleWithEventLogging(keys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Map<K, ICacheElement<K, V>> getMultipleWithEventLogging(Set<K> keys) throws IOException {
        ICacheEvent<Serializable> cacheEvent = this.createICacheEvent(this.getCacheName(), (Serializable)((Object)keys), "getMultiple");
        try {
            Map<K, ICacheElement<K, V>> map = this.processGetMultiple(keys);
            return map;
        }
        finally {
            this.logICacheEvent(cacheEvent);
        }
    }

    protected abstract Map<K, ICacheElement<K, V>> processGetMultiple(Set<K> var1) throws IOException;

    @Override
    public Map<K, ICacheElement<K, V>> getMatching(String pattern) throws IOException {
        return this.getMatchingWithEventLogging(pattern);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Map<K, ICacheElement<K, V>> getMatchingWithEventLogging(String pattern) throws IOException {
        ICacheEvent<String> cacheEvent = this.createICacheEvent(this.getCacheName(), pattern, "getMatching");
        try {
            Map<K, ICacheElement<K, V>> map = this.processGetMatching(pattern);
            return map;
        }
        finally {
            this.logICacheEvent(cacheEvent);
        }
    }

    protected abstract Map<K, ICacheElement<K, V>> processGetMatching(String var1) throws IOException;

    @Override
    public boolean remove(K key) throws IOException {
        return this.removeWithEventLogging(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean removeWithEventLogging(K key) throws IOException {
        ICacheEvent<K> cacheEvent = this.createICacheEvent(this.getCacheName(), key, "remove");
        try {
            boolean bl = this.processRemove(key);
            return bl;
        }
        finally {
            this.logICacheEvent(cacheEvent);
        }
    }

    protected abstract boolean processRemove(K var1) throws IOException;

    @Override
    public void removeAll() throws IOException {
        this.removeAllWithEventLogging();
    }

    protected final void removeAllWithEventLogging() throws IOException {
        ICacheEvent<String> cacheEvent = this.createICacheEvent(this.getCacheName(), "all", "removeAll");
        try {
            this.processRemoveAll();
        }
        finally {
            this.logICacheEvent(cacheEvent);
        }
    }

    protected abstract void processRemoveAll() throws IOException;

    @Override
    public void dispose() throws IOException {
        this.disposeWithEventLogging();
    }

    protected final void disposeWithEventLogging() throws IOException {
        ICacheEvent<String> cacheEvent = this.createICacheEvent(this.getCacheName(), "none", "dispose");
        try {
            this.processDispose();
        }
        finally {
            this.logICacheEvent(cacheEvent);
        }
    }

    protected abstract void processDispose() throws IOException;
}

