/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.criteria;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.torque.criteria.PreparedStatementPart;
import org.apache.torque.criteria.SqlEnum;

public class PreparedStatementPartImpl
implements PreparedStatementPart,
Serializable {
    private static final long serialVersionUID = 1L;
    private final StringBuilder sql = new StringBuilder();
    private final List<Object> preparedStatementReplacements = new ArrayList<Object>();

    public PreparedStatementPartImpl() {
    }

    public PreparedStatementPartImpl(String sql, Object ... preparedStatementReplacements) {
        if (!StringUtils.isEmpty((CharSequence)sql)) {
            this.sql.append(sql);
        }
        if (preparedStatementReplacements != null) {
            this.preparedStatementReplacements.addAll(Arrays.asList(preparedStatementReplacements));
        }
    }

    public PreparedStatementPartImpl(PreparedStatementPart toCopy) {
        String sqlAsString = toCopy.getSqlAsString();
        if (!StringUtils.isEmpty((CharSequence)sqlAsString)) {
            this.sql.append(sqlAsString);
        }
        if (toCopy.getPreparedStatementReplacements() != null) {
            this.preparedStatementReplacements.addAll(toCopy.getPreparedStatementReplacements());
        }
    }

    public StringBuilder getSql() {
        return this.sql;
    }

    @Override
    public String getSqlAsString() {
        return this.sql.toString();
    }

    @Override
    public List<Object> getPreparedStatementReplacements() {
        return this.preparedStatementReplacements;
    }

    public PreparedStatementPartImpl append(PreparedStatementPart toAppend) {
        this.sql.append(toAppend.getSqlAsString());
        this.preparedStatementReplacements.addAll(toAppend.getPreparedStatementReplacements());
        return this;
    }

    public PreparedStatementPartImpl append(SqlEnum toAppend) {
        this.sql.append(toAppend);
        return this;
    }

    public int hashCode() {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
        hashCodeBuilder.append((Object)this.sql);
        hashCodeBuilder.append(this.preparedStatementReplacements);
        return hashCodeBuilder.toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PreparedStatementPartImpl other = (PreparedStatementPartImpl)obj;
        EqualsBuilder equalsBuilder = new EqualsBuilder();
        equalsBuilder.append((Object)other.sql, (Object)this.sql);
        equalsBuilder.append(other.preparedStatementReplacements, this.preparedStatementReplacements);
        return equalsBuilder.isEquals();
    }

    public String toString() {
        return this.sql + ", preparedStatementReplacements=" + this.preparedStatementReplacements;
    }
}

