/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.configuration.outlet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.torque.generator.configuration.ConfigurationException;
import org.apache.torque.generator.configuration.ConfigurationHandlers;
import org.apache.torque.generator.configuration.ConfigurationProvider;
import org.apache.torque.generator.configuration.UnitDescriptor;
import org.apache.torque.generator.configuration.outlet.GroovyOutletSaxHandler;
import org.apache.torque.generator.configuration.outlet.OutletConfigurationXmlParser;
import org.apache.torque.generator.configuration.outlet.OutletSaxHandler;
import org.apache.torque.generator.configuration.outlet.TypedOutletSaxHandlerFactory;
import org.apache.torque.generator.outlet.Outlet;
import org.apache.torque.generator.qname.QualifiedName;
import org.apache.torque.generator.template.groovy.GroovyScriptOutlet;
import org.xml.sax.SAXException;

public class GroovyOutletSaxHandlerFactory
implements TypedOutletSaxHandlerFactory {
    private static final String OUTLET_TYPE = "groovyOutlet";
    private static final List<String> TEMPLATE_FILENAMES_EXTENSIONS;

    @Override
    public String getType() {
        return OUTLET_TYPE;
    }

    @Override
    public Collection<String> getTemplatesFilenameExtensionsForScan() {
        return TEMPLATE_FILENAMES_EXTENSIONS;
    }

    @Override
    public Outlet createOutletForTemplate(String templatePath, ConfigurationProvider configurationProvider) throws ConfigurationException {
        GroovyScriptOutlet result = new GroovyScriptOutlet(OutletConfigurationXmlParser.getOutletNameForFilename(templatePath), configurationProvider, templatePath, null);
        return result;
    }

    @Override
    public final OutletSaxHandler getOutletSaxHandler(QualifiedName outletName, ConfigurationProvider configurationProvider, UnitDescriptor unitDescriptor, ConfigurationHandlers configurationHandlers) throws SAXException {
        return new GroovyOutletSaxHandler(outletName, configurationProvider, unitDescriptor, configurationHandlers);
    }

    static {
        ArrayList<String> templateFilenameExtensions = new ArrayList<String>();
        templateFilenameExtensions.add(".groovy");
        TEMPLATE_FILENAMES_EXTENSIONS = Collections.unmodifiableList(templateFilenameExtensions);
    }
}

