/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.scalar;

import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.data.binary.BinaryStringData;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.SpecializedFunction;
import org.apache.flink.table.runtime.functions.SqlJsonUtils;
import org.apache.flink.table.runtime.functions.scalar.BuiltInScalarFunction;

@Internal
public class JsonUnquoteFunction
extends BuiltInScalarFunction {
    public JsonUnquoteFunction(SpecializedFunction.SpecializedContext context) {
        super(BuiltInFunctionDefinitions.JSON_UNQUOTE, context);
    }

    @Nullable
    public Object eval(Object input) {
        if (input == null) {
            return null;
        }
        BinaryStringData bs = (BinaryStringData)input;
        String inputStr = bs.toString();
        try {
            if (JsonUnquoteFunction.isValidJsonVal(inputStr)) {
                return new BinaryStringData(this.unescapeValidJson(inputStr));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return new BinaryStringData(inputStr);
    }

    private static boolean isValidJsonVal(String jsonInString) {
        return SqlJsonUtils.isJsonValue(jsonInString);
    }

    private static String fromUnicodeLiteral(String input, int curPos) {
        StringBuilder number = new StringBuilder();
        for (char ch : input.substring(curPos, curPos + 4).toCharArray()) {
            number.append(Character.toLowerCase(ch));
        }
        int code = Integer.parseInt(number.toString(), 16);
        return String.valueOf((char)code);
    }

    private String unescapeStr(String inputStr) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        block11: while (i < inputStr.length()) {
            if (inputStr.charAt(i) == '\\' && i + 1 < inputStr.length()) {
                int n = ++i;
                ++i;
                char ch = inputStr.charAt(n);
                switch (ch) {
                    case '\"': {
                        result.append(ch);
                        continue block11;
                    }
                    case '\\': {
                        result.append(ch);
                        continue block11;
                    }
                    case '/': {
                        result.append(ch);
                        continue block11;
                    }
                    case 'b': {
                        result.append('\b');
                        continue block11;
                    }
                    case 'f': {
                        result.append('\f');
                        continue block11;
                    }
                    case 'n': {
                        result.append('\n');
                        continue block11;
                    }
                    case 'r': {
                        result.append('\r');
                        continue block11;
                    }
                    case 't': {
                        result.append('\t');
                        continue block11;
                    }
                    case 'u': {
                        result.append(JsonUnquoteFunction.fromUnicodeLiteral(inputStr, i));
                        i += 4;
                        continue block11;
                    }
                }
                throw new IllegalArgumentException("Illegal escape sequence: \\" + ch);
            }
            result.append(inputStr.charAt(i));
            ++i;
        }
        return result.toString();
    }

    private String unescapeValidJson(String inputStr) {
        if (inputStr.charAt(0) == '\"' && inputStr.charAt(inputStr.length() - 1) == '\"') {
            return this.unescapeStr(inputStr.substring(1, inputStr.length() - 1));
        }
        return inputStr;
    }
}

