/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog.listener;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.catalog.CatalogModel;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.listener.CatalogContext;
import org.apache.flink.table.catalog.listener.CatalogModificationEvent;

@PublicEvolving
public interface AlterModelEvent
extends CatalogModificationEvent {
    public ObjectIdentifier identifier();

    public CatalogModel model();

    public CatalogModel newModel();

    public boolean ignoreIfNotExists();

    public static AlterModelEvent createEvent(final CatalogContext context, final ObjectIdentifier identifier, final CatalogModel newModel, final boolean ignoreIfNotExists) {
        return new AlterModelEvent(){

            @Override
            public CatalogModel newModel() {
                return newModel;
            }

            @Override
            public boolean ignoreIfNotExists() {
                return ignoreIfNotExists;
            }

            @Override
            public ObjectIdentifier identifier() {
                return identifier;
            }

            @Override
            public CatalogModel model() {
                throw new IllegalStateException("There is no model in AlterModelEvent, use identifier() instead.");
            }

            @Override
            public CatalogContext context() {
                return context;
            }
        };
    }
}

