/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.admin.jmx.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.geode.SystemFailure;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

@Deprecated
public class MailManager {
    private static final Logger logger = LogService.getLogger();
    private final HashSet mailToSet = new HashSet();
    private String[] mailToAddresses = new String[0];
    protected String mailHost;
    protected String mailFrom;
    public static final String PROPERTY_MAIL_HOST = "mail.host";
    public static final String PROPERTY_MAIL_FROM = "mail.from";
    public static final String PROPERTY_MAIL_TO_LIST = "mail.toList";

    public MailManager() {
    }

    public MailManager(Properties mailProperties) {
        this.setMailProperties(mailProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MailManager(File mailPropertiesFile) throws IOException {
        Properties prop = new Properties();
        try (FileInputStream fio = new FileInputStream(mailPropertiesFile);){
            prop.load(fio);
        }
        this.setMailProperties(prop);
    }

    public MailManager(String mailHost, String mailFrom) {
        this.mailHost = mailHost;
        this.mailFrom = mailFrom;
    }

    public void sendEmail(String subject, String message) {
        this.processEmail(new EmailData(subject, message));
    }

    private void processEmail(EmailData emailData) {
        if (logger.isTraceEnabled()) {
            logger.trace("Entered MailManager:processEmail");
        }
        if (this.mailHost == null || this.mailHost.length() == 0 || emailData == null || this.mailToAddresses.length == 0) {
            logger.error("Required mail server configuration is not specfied.");
            if (logger.isDebugEnabled()) {
                logger.debug("Exited MailManager:processEmail: Not sending email as conditions not met");
            }
            return;
        }
        Session session = Session.getDefaultInstance((Properties)this.getMailHostConfiguration());
        MimeMessage mimeMessage = new MimeMessage(session);
        String subject = emailData.subject;
        String message = emailData.message;
        String mailToList = this.getMailToAddressesAsString();
        try {
            for (String mailToAddress : this.mailToAddresses) {
                mimeMessage.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(mailToAddress));
            }
            if (subject == null) {
                subject = "Alert from GemFire Admin Agent";
            }
            mimeMessage.setSubject(subject);
            if (message == null) {
                message = "";
            }
            mimeMessage.setText(message);
            Transport.send((Message)mimeMessage);
            logger.info("Email sent to {}. Subject: {}, Content: {}", new Object[]{mailToList, subject, message});
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable ex) {
            SystemFailure.checkFailure();
            String buf = "An exception occurred while sending email.Unable to send email. Please check your mail settings and the log file.\n\n" + String.format("Exception message: %s", ex.getMessage()) + "\n\nFollowing email was not delivered:\n\t" + String.format("Mail Host: %s", this.mailHost) + "\n\t" + String.format("From: %s", this.mailFrom) + "\n\t" + String.format("To: %s", mailToList) + "\n\t" + String.format("Subject: %s", subject) + "\n\t" + String.format("Content: %s", message);
            logger.error(buf, ex);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Exited MailManager:processEmail");
        }
    }

    public void close() {
    }

    private String getMailToAddressesAsString() {
        StringBuilder mailToList = new StringBuilder();
        for (String mailToAddress : this.mailToAddresses) {
            mailToList.append(mailToAddress);
            mailToList.append(", ");
        }
        return mailToList.toString();
    }

    private Properties getMailHostConfiguration() {
        Properties result = new Properties();
        if (this.mailHost == null) {
            this.mailHost = "";
        }
        if (this.mailFrom == null) {
            this.mailFrom = "";
        }
        result.setProperty(PROPERTY_MAIL_HOST, this.mailHost);
        result.put(PROPERTY_MAIL_FROM, this.mailFrom);
        return result;
    }

    public void setMailHost(String host) {
        this.mailHost = host;
    }

    public String getMailHost() {
        return this.mailHost;
    }

    public void setMailFromAddress(String fromAddress) {
        this.mailFrom = fromAddress;
    }

    public String getMailFromAddress() {
        return this.mailFrom;
    }

    public void addMailToAddress(String toAddress) {
        this.mailToSet.add(toAddress);
        this.mailToAddresses = this.getAllToAddresses();
    }

    public void removeMailToAddress(String toAddress) {
        this.mailToSet.remove(toAddress);
        this.mailToAddresses = this.getAllToAddresses();
    }

    public String[] getAllToAddresses() {
        return this.mailToSet.toArray(new String[0]);
    }

    public void removeAllMailToAddresses() {
        this.mailToSet.clear();
        this.mailToAddresses = new String[0];
    }

    public void setMailProperties(Properties mailProperties) {
        this.mailHost = mailProperties.getProperty(PROPERTY_MAIL_HOST);
        this.mailFrom = mailProperties.getProperty(PROPERTY_MAIL_FROM);
        String mailList = mailProperties.getProperty(PROPERTY_MAIL_TO_LIST, "");
        String[] split = mailList.split(",");
        this.removeAllMailToAddresses();
        for (String s : split) {
            this.addMailToAddress(s.trim());
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(200);
        buffer.append("[Mail Host: ");
        buffer.append(this.getMailHost());
        buffer.append("]");
        buffer.append(" [Mail From: ");
        buffer.append(this.getMailFromAddress());
        buffer.append("]");
        buffer.append(" [Mail To: ");
        if (this.mailToAddresses.length > 0) {
            for (String mailToAddress : this.mailToAddresses) {
                buffer.append(mailToAddress);
                buffer.append(", ");
            }
            buffer.replace(buffer.length() - 2, buffer.length(), "");
        } else {
            buffer.append(" Undefined");
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static void main(String[] args) {
        MailManager mailManager = new MailManager("mailsrv1.gemstone.com", "hkhanna@gemstone.com");
        mailManager.sendEmail("Alert!", "Test");
    }

    private static class EmailData {
        String subject;
        String message;

        EmailData(String subject, String message) {
            this.subject = subject;
            this.message = message;
        }
    }
}

