/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.logging;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import org.apache.geode.internal.logging.DateFormatter;
import org.apache.geode.internal.logging.LogWriterImpl;

public class GemFireFormatter
extends Formatter {
    private final DateFormat dateFormat = DateFormatter.createDateFormat();

    @Override
    public String format(LogRecord record) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println();
        pw.print('[');
        pw.print(record.getLevel().getName());
        pw.print(' ');
        pw.print(this.dateFormat.format(new Date(record.getMillis())));
        String threadName = Thread.currentThread().getName();
        if (threadName != null) {
            pw.print(' ');
            pw.print(threadName);
        }
        pw.print(" tid=0x");
        pw.print(Long.toHexString(Thread.currentThread().getId()));
        pw.print("] ");
        pw.print("(msgTID=");
        pw.print(record.getThreadID());
        pw.print(" msgSN=");
        pw.print(record.getSequenceNumber());
        pw.print(") ");
        String msg = record.getMessage();
        if (msg != null) {
            try {
                LogWriterImpl.formatText(pw, msg, 40);
            }
            catch (RuntimeException e) {
                pw.println(msg);
                pw.println("Ignoring the following exception:");
                e.printStackTrace(pw);
            }
        } else {
            pw.println();
        }
        if (record.getThrown() != null) {
            record.getThrown().printStackTrace(pw);
        }
        pw.close();
        try {
            sw.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sw.toString();
    }
}

