/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.monitoring;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.monitoring.ThreadsMonitoring;
import org.apache.geode.internal.monitoring.ThreadsMonitoringProcess;
import org.apache.geode.internal.monitoring.executor.AbstractExecutor;
import org.apache.geode.internal.monitoring.executor.FunctionExecutionPooledExecutorGroup;
import org.apache.geode.internal.monitoring.executor.GatewaySenderEventProcessorGroup;
import org.apache.geode.internal.monitoring.executor.OneTaskOnlyExecutorGroup;
import org.apache.geode.internal.monitoring.executor.P2PReaderExecutorGroup;
import org.apache.geode.internal.monitoring.executor.PooledExecutorGroup;
import org.apache.geode.internal.monitoring.executor.ScheduledThreadPoolExecutorWKAGroup;
import org.apache.geode.internal.monitoring.executor.SerialQueuedExecutorGroup;
import org.apache.geode.internal.monitoring.executor.ServerConnectionExecutorGroup;

public class ThreadsMonitoringImpl
implements ThreadsMonitoring {
    private final ConcurrentMap<Long, AbstractExecutor> monitorMap = new ConcurrentHashMap<Long, AbstractExecutor>();
    private ThreadsMonitoringProcess tmProcess = null;
    private final Timer timer;
    private boolean isClosed = false;

    public ThreadsMonitoringImpl(InternalDistributedSystem iDistributedSystem, int timeIntervalMillis, int timeLimitMillis) {
        this(iDistributedSystem, timeIntervalMillis, timeLimitMillis, true);
    }

    @VisibleForTesting
    ThreadsMonitoringImpl(InternalDistributedSystem iDistributedSystem, int timeIntervalMillis, int timeLimitMillis, boolean startThread) {
        if (startThread) {
            this.timer = new Timer("ThreadsMonitor", true);
            this.tmProcess = new ThreadsMonitoringProcess(this, iDistributedSystem, timeLimitMillis);
            this.timer.schedule((TimerTask)this.tmProcess, 0L, (long)timeIntervalMillis);
        } else {
            this.timer = null;
        }
    }

    public ConcurrentMap<Long, AbstractExecutor> getMonitorMap() {
        return this.monitorMap;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public void close() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        if (this.timer != null) {
            this.timer.cancel();
            this.tmProcess = null;
        }
        this.monitorMap.clear();
    }

    public ThreadsMonitoringProcess getThreadsMonitoringProcess() {
        return this.tmProcess;
    }

    @Override
    public void updateThreadStatus() {
        AbstractExecutor executor = (AbstractExecutor)this.monitorMap.get(Thread.currentThread().getId());
        if (executor != null) {
            executor.setStartTime(System.currentTimeMillis());
        }
    }

    @Override
    public boolean startMonitor(ThreadsMonitoring.Mode mode) {
        AbstractExecutor executor = this.createAbstractExecutor(mode);
        executor.setStartTime(System.currentTimeMillis());
        return this.register(executor);
    }

    @Override
    public void endMonitor() {
        this.monitorMap.remove(Thread.currentThread().getId());
    }

    @VisibleForTesting
    boolean isMonitoring() {
        AbstractExecutor executor = (AbstractExecutor)this.monitorMap.get(Thread.currentThread().getId());
        if (executor == null) {
            return false;
        }
        return !executor.isMonitoringSuspended();
    }

    @Override
    public AbstractExecutor createAbstractExecutor(ThreadsMonitoring.Mode mode) {
        switch (mode) {
            case FunctionExecutor: {
                return new FunctionExecutionPooledExecutorGroup();
            }
            case PooledExecutor: {
                return new PooledExecutorGroup();
            }
            case SerialQueuedExecutor: {
                return new SerialQueuedExecutorGroup();
            }
            case OneTaskOnlyExecutor: {
                return new OneTaskOnlyExecutorGroup();
            }
            case ScheduledThreadExecutor: {
                return new ScheduledThreadPoolExecutorWKAGroup();
            }
            case AGSExecutor: {
                return new GatewaySenderEventProcessorGroup();
            }
            case P2PReaderExecutor: {
                return new P2PReaderExecutorGroup();
            }
            case ServerConnectionExecutor: {
                return new ServerConnectionExecutorGroup();
            }
        }
        throw new IllegalStateException("Unhandled mode=" + (Object)((Object)mode));
    }

    @Override
    public boolean register(AbstractExecutor executor) {
        this.monitorMap.put(executor.getThreadID(), executor);
        return true;
    }

    @Override
    public void unregister(AbstractExecutor executor) {
        this.monitorMap.remove(executor.getThreadID());
    }

    @VisibleForTesting
    boolean isMonitoring(AbstractExecutor executor) {
        if (executor.isMonitoringSuspended()) {
            return false;
        }
        return this.monitorMap.containsKey(executor.getThreadID());
    }

    @VisibleForTesting
    Timer getTimer() {
        return this.timer;
    }
}

