/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.listener.api.event;

import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.annotation.DeveloperApi;
import org.apache.gravitino.iceberg.service.IcebergRestUtils;
import org.apache.gravitino.listener.api.event.IcebergRequestContext;
import org.apache.gravitino.listener.api.event.IcebergViewEvent;
import org.apache.gravitino.listener.api.event.OperationType;
import org.apache.iceberg.rest.requests.CreateViewRequest;
import org.apache.iceberg.rest.responses.LoadViewResponse;

@DeveloperApi
public class IcebergCreateViewEvent
extends IcebergViewEvent {
    private final CreateViewRequest createViewRequest;
    private final LoadViewResponse loadViewResponse;

    public IcebergCreateViewEvent(IcebergRequestContext icebergRequestContext, NameIdentifier viewIdentifier, CreateViewRequest createViewRequest, LoadViewResponse loadViewResponse) {
        super(icebergRequestContext, viewIdentifier);
        this.createViewRequest = IcebergRestUtils.cloneIcebergRESTObject(createViewRequest, CreateViewRequest.class);
        this.loadViewResponse = IcebergRestUtils.cloneIcebergRESTObject(loadViewResponse, LoadViewResponse.class);
    }

    public CreateViewRequest createViewRequest() {
        return this.createViewRequest;
    }

    public LoadViewResponse loadViewResponse() {
        return this.loadViewResponse;
    }

    public OperationType operationType() {
        return OperationType.CREATE_VIEW;
    }
}

