/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.iceberg.service.provider;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.Catalog;
import org.apache.gravitino.Config;
import org.apache.gravitino.GravitinoEnv;
import org.apache.gravitino.auth.AuthProperties;
import org.apache.gravitino.client.DefaultOAuth2TokenProvider;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.client.OAuth2TokenProvider;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.iceberg.common.IcebergConfig;
import org.apache.gravitino.iceberg.service.provider.IcebergConfigProvider;
import org.apache.gravitino.server.web.JettyServerConfig;
import org.apache.gravitino.utils.MapUtils;

public class DynamicIcebergConfigProvider
implements IcebergConfigProvider {
    private String gravitinoMetalake;
    private String gravitinoUri;
    private Optional<String> defaultDynamicCatalogName;
    private Map<String, String> properties;
    private volatile GravitinoClient client;

    @Override
    public void initialize(Map<String, String> properties) {
        String uri = properties.get("gravitino-uri");
        String metalake = properties.get("gravitino-metalake");
        if (StringUtils.isBlank((CharSequence)uri)) {
            JettyServerConfig config = JettyServerConfig.fromConfig((Config)GravitinoEnv.getInstance().config(), (String)"gravitino.server.webserver.");
            uri = String.format("http://%s:%d", config.getHost(), config.getHttpPort());
        }
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)uri), (Object)"gravitino-uri is blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)metalake), (Object)"gravitino-metalake is blank");
        this.gravitinoMetalake = metalake;
        this.gravitinoUri = uri;
        this.defaultDynamicCatalogName = Optional.ofNullable(properties.get("default-catalog-name"));
        this.properties = properties;
    }

    @Override
    public Optional<IcebergConfig> getIcebergCatalogConfig(String catalogName) {
        Catalog catalog;
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)catalogName), (Object)"blank catalogName is illegal");
        if (catalogName.equals("default_catalog")) {
            catalogName = this.defaultDynamicCatalogName.orElseThrow(() -> new IllegalArgumentException(String.format("For dynamic config provider, Please use `%s` in iceberg client side to specify the catalog name or setting `%s` in REST server side to specify the default catalog name.", "warehouse", "gravitino.iceberg-rest.default-catalog-name")));
        }
        try {
            catalog = this.getGravitinoClient().loadMetalake(this.gravitinoMetalake).loadCatalog(catalogName);
        }
        catch (NoSuchCatalogException e) {
            return Optional.empty();
        }
        Preconditions.checkArgument((boolean)"lakehouse-iceberg".equals(catalog.provider()), (Object)String.format("%s.%s is not iceberg catalog", this.gravitinoMetalake, catalogName));
        return Optional.of(DynamicIcebergConfigProvider.getIcebergConfigFromCatalogProperties(catalog.properties()));
    }

    @VisibleForTesting
    void setClient(GravitinoClient client) {
        this.client = client;
    }

    @Override
    public void close() {
        if (this.client != null) {
            this.client.close();
        }
    }

    @Override
    public String getMetalakeName() {
        return this.gravitinoMetalake;
    }

    @VisibleForTesting
    static IcebergConfig getIcebergConfigFromCatalogProperties(Map<String, String> catalogProperties) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.putAll(MapUtils.getPrefixMap(catalogProperties, (String)"gravitino.bypass."));
        properties.putAll(catalogProperties);
        return new IcebergConfig(properties);
    }

    @Override
    public String getDefaultCatalogName() {
        return this.defaultDynamicCatalogName.orElse("default_catalog");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GravitinoClient getGravitinoClient() {
        if (this.client != null) {
            return this.client;
        }
        DynamicIcebergConfigProvider dynamicIcebergConfigProvider = this;
        synchronized (dynamicIcebergConfigProvider) {
            if (this.client == null) {
                this.client = this.createGravitinoClient(this.gravitinoUri, this.gravitinoMetalake, this.properties);
            }
        }
        return this.client;
    }

    private GravitinoClient createGravitinoClient(String uri, String metalake, Map<String, String> properties) {
        GravitinoClient.ClientBuilder builder = GravitinoClient.builder((String)uri).withMetalake(metalake);
        String authType = properties.getOrDefault("gravitino-auth-type", "simple");
        if (AuthProperties.isSimple((String)authType)) {
            String userName = properties.getOrDefault("gravitino-simple.user-name", "iceberg-rest-server");
            builder.withSimpleAuth(userName);
        } else if (AuthProperties.isOAuth2((String)authType)) {
            String oAuthUri = this.getRequiredConfig(properties, "gravitino-oauth2.server-uri");
            String credential = this.getRequiredConfig(properties, "gravitino-oauth2.credential");
            String path = this.getRequiredConfig(properties, "gravitino-oauth2.token-path");
            String scope = this.getRequiredConfig(properties, "gravitino-oauth2.scope");
            DefaultOAuth2TokenProvider oAuth2TokenProvider = (DefaultOAuth2TokenProvider)((DefaultOAuth2TokenProvider.Builder)DefaultOAuth2TokenProvider.builder().withUri(oAuthUri)).withCredential(credential).withPath(path).withScope(scope).build();
            builder.withOAuth((OAuth2TokenProvider)oAuth2TokenProvider);
        } else {
            throw new UnsupportedOperationException("Unsupported auth type: " + authType);
        }
        return builder.build();
    }

    private String getRequiredConfig(Map<String, String> properties, String key) {
        String configValue = properties.get(key);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)configValue), (Object)(key + " should not be empty"));
        return configValue;
    }
}

