/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOp;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FSEditLogAsync
extends FSEditLog
implements Runnable {
    static final Logger LOG = LoggerFactory.getLogger(FSEditLog.class);
    private final Object syncThreadLock = new Object();
    private Thread syncThread;
    private static final ThreadLocal<Edit> THREAD_EDIT = new ThreadLocal();
    private final BlockingQueue<Edit> editPendingQ = new ArrayBlockingQueue<Edit>(4096);
    private final Deque<Edit> syncWaitQ = new ArrayDeque<Edit>();
    private long lastFull = 0L;
    private Semaphore overflowMutex = new Semaphore(8){
        private AtomicBoolean draining;
        private AtomicInteger pendingReleases;
        {
            this.draining = new AtomicBoolean();
            this.pendingReleases = new AtomicInteger();
        }

        @Override
        public int drainPermits() {
            this.draining.set(true);
            return super.drainPermits();
        }

        private void tryRelease(int permits) {
            this.pendingReleases.getAndAdd(permits);
            if (!this.draining.get()) {
                super.release(this.pendingReleases.getAndSet(0));
            }
        }

        @Override
        public void release() {
            this.tryRelease(1);
        }

        @Override
        public void release(int permits) {
            this.draining.set(false);
            this.tryRelease(permits);
        }
    };

    FSEditLogAsync(Configuration conf, NNStorage storage, List<URI> editsDirs) {
        super(conf, storage, editsDirs);
        this.cache.disableCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSyncThreadAlive() {
        Object object = this.syncThreadLock;
        synchronized (object) {
            return this.syncThread != null && this.syncThread.isAlive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startSyncThread() {
        Object object = this.syncThreadLock;
        synchronized (object) {
            if (!this.isSyncThreadAlive()) {
                this.syncThread = new Thread((Runnable)this, this.getClass().getSimpleName());
                this.syncThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopSyncThread() {
        Object object = this.syncThreadLock;
        synchronized (object) {
            if (this.syncThread != null) {
                try {
                    this.syncThread.interrupt();
                    this.syncThread.join();
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    this.syncThread = null;
                }
            }
        }
    }

    @Override
    @VisibleForTesting
    public void restart() {
        this.stopSyncThread();
        this.startSyncThread();
    }

    @Override
    void openForWrite(int layoutVersion) throws IOException {
        try {
            this.startSyncThread();
            super.openForWrite(layoutVersion);
        }
        catch (IOException ioe) {
            this.stopSyncThread();
            throw ioe;
        }
    }

    @Override
    public void close() {
        super.close();
        this.stopSyncThread();
    }

    @Override
    void logEdit(FSEditLogOp op) {
        Edit edit = this.getEditInstance(op);
        THREAD_EDIT.set(edit);
        this.enqueueEdit(edit);
    }

    @Override
    public void logSync() {
        Edit edit = THREAD_EDIT.get();
        if (edit != null) {
            THREAD_EDIT.set(null);
            if (LOG.isDebugEnabled()) {
                LOG.debug("logSync " + edit);
            }
            edit.logSyncWait();
        }
    }

    @Override
    public void logSyncAll() {
        SyncEdit edit = new SyncEdit(this, null){

            @Override
            public boolean logEdit() {
                return true;
            }
        };
        this.enqueueEdit(edit);
        ((Edit)edit).logSyncWait();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueEdit(Edit edit) {
        block12: {
            if (LOG.isDebugEnabled()) {
                LOG.debug("logEdit " + edit);
            }
            try {
                if (this.editPendingQ.offer(edit)) break block12;
                Preconditions.checkState((boolean)this.isSyncThreadAlive(), (Object)"sync thread is not alive");
                long now = Time.monotonicNow();
                if (now - this.lastFull > 4000L) {
                    this.lastFull = now;
                    LOG.info("Edit pending queue is full");
                }
                if (Thread.holdsLock(this)) {
                    int permits = this.overflowMutex.drainPermits();
                    try {
                        do {
                            this.wait(1000L);
                        } while (!this.editPendingQ.offer(edit));
                        break block12;
                    }
                    finally {
                        this.overflowMutex.release(permits);
                    }
                }
                this.overflowMutex.acquire();
                try {
                    this.editPendingQ.put(edit);
                }
                finally {
                    this.overflowMutex.release();
                }
            }
            catch (Throwable t) {
                this.terminate(t);
            }
        }
    }

    private Edit dequeueEdit() throws InterruptedException {
        return this.syncWaitQ.isEmpty() ? this.editPendingQ.take() : (Edit)this.editPendingQ.poll();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        try {
            block5: while (true) {
                metrics = NameNode.getNameNodeMetrics();
                edit = this.dequeueEdit();
                if (edit != null) {
                    doSync = edit.logEdit();
                    this.syncWaitQ.add(edit);
                    metrics.setPendingEditsCount(this.editPendingQ.size() + 1);
                } else {
                    doSync = this.syncWaitQ.isEmpty() == false;
                    metrics.setPendingEditsCount(0);
                }
                if (!doSync) continue;
                syncEx = null;
                try {
                    this.logSync(this.getLastWrittenTxId());
                }
                catch (RuntimeException ex) {
                    syncEx = ex;
                }
                while (true) {
                    if ((edit = this.syncWaitQ.poll()) != null) ** break;
                    continue block5;
                    edit.logSyncNotify(syncEx);
                }
                break;
            }
        }
        catch (InterruptedException ie) {
            FSEditLogAsync.LOG.info(Thread.currentThread().getName() + " was interrupted, exiting");
        }
        catch (Throwable t) {
            this.terminate(t);
        }
    }

    private void terminate(Throwable t) {
        String message = "Exception while edit logging: " + t.getMessage();
        LOG.error(message, t);
        ExitUtil.terminate((int)1, (String)message);
    }

    private Edit getEditInstance(FSEditLogOp op) {
        Server.Call rpcCall = (Server.Call)Server.getCurCall().get();
        Edit edit = rpcCall != null && !Thread.holdsLock(this) ? new RpcEdit(this, op, rpcCall) : new SyncEdit(this, op);
        return edit;
    }

    private static class RpcEdit
    extends Edit {
        private final Server.Call call;

        RpcEdit(FSEditLog log, FSEditLogOp op, Server.Call call) {
            super(log, op);
            this.call = call;
            call.postponeResponse();
        }

        @Override
        public void logSyncWait() {
        }

        @Override
        public void logSyncNotify(RuntimeException syncEx) {
            try {
                if (syncEx == null) {
                    this.call.sendResponse();
                } else {
                    this.call.abortResponse((Throwable)syncEx);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public String toString() {
            return "[" + this.getClass().getSimpleName() + " op:" + this.op + " call:" + this.call + "]";
        }
    }

    private static class SyncEdit
    extends Edit {
        private final Object lock;
        private boolean done = false;
        private RuntimeException syncEx;

        SyncEdit(FSEditLog log, FSEditLogOp op) {
            super(log, op);
            this.lock = Thread.holdsLock(log) ? log : this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void logSyncWait() {
            Object object = this.lock;
            synchronized (object) {
                while (!this.done) {
                    try {
                        this.lock.wait(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.syncEx != null) {
                    this.syncEx.fillInStackTrace();
                    throw this.syncEx;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void logSyncNotify(RuntimeException ex) {
            Object object = this.lock;
            synchronized (object) {
                this.done = true;
                this.syncEx = ex;
                this.lock.notifyAll();
            }
        }

        public String toString() {
            return "[" + this.getClass().getSimpleName() + " op:" + this.op + "]";
        }
    }

    private static abstract class Edit {
        final FSEditLog log;
        final FSEditLogOp op;

        Edit(FSEditLog log, FSEditLogOp op) {
            this.log = log;
            this.op = op;
        }

        boolean logEdit() {
            return this.log.doEditTransaction(this.op);
        }

        abstract void logSyncWait();

        abstract void logSyncNotify(RuntimeException var1);
    }
}

