/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.lance.server;

import org.apache.gravitino.Config;
import org.apache.gravitino.GravitinoEnv;
import org.apache.gravitino.lance.LanceRESTService;
import org.apache.gravitino.server.ServerConfig;
import org.apache.gravitino.server.authentication.ServerAuthenticator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GravitinoLanceRESTServer {
    private static final Logger LOG = LoggerFactory.getLogger(GravitinoLanceRESTServer.class);
    public static final String CONF_FILE = "gravitino-lance-rest-server.conf";
    private final Config serverConfig;
    private LanceRESTService lanceRESTService;
    private GravitinoEnv gravitinoEnv;

    public GravitinoLanceRESTServer(Config config) {
        this.serverConfig = config;
        this.gravitinoEnv = GravitinoEnv.getInstance();
        this.lanceRESTService = new LanceRESTService();
    }

    private void initialize() {
        this.gravitinoEnv.initializeBaseComponents(this.serverConfig);
        this.lanceRESTService.serviceInit(this.serverConfig.getConfigsWithPrefix("gravitino.lance-rest."));
        ServerAuthenticator.getInstance().initialize(this.serverConfig);
    }

    private void start() {
        this.gravitinoEnv.start();
        this.lanceRESTService.serviceStart();
    }

    private void join() {
        this.lanceRESTService.join();
    }

    private void stop() throws Exception {
        this.lanceRESTService.serviceStop();
        LOG.info("Gravitino Lance REST service stopped");
    }

    public static void main(String[] args) {
        LOG.info("Starting Gravitino Lance REST Server");
        String confPath = System.getenv("GRAVITINO_TEST") == null ? "" : args[0];
        ServerConfig serverConfig = ServerConfig.loadConfig((String)confPath, (String)CONF_FILE);
        GravitinoLanceRESTServer lanceRESTServer = new GravitinoLanceRESTServer((Config)serverConfig);
        lanceRESTServer.initialize();
        try {
            lanceRESTServer.start();
        }
        catch (Exception e) {
            LOG.error("Error while running lance REST server", (Throwable)e);
            System.exit(-1);
        }
        LOG.info("Done, Gravitino Lance REST server started.");
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                Thread.sleep(((Integer)serverConfig.get(ServerConfig.SERVER_SHUTDOWN_TIMEOUT)).intValue());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOG.error("Interrupted exception:", (Throwable)e);
            }
            catch (Exception e) {
                LOG.error("Error while running clean-up tasks in shutdown hook", (Throwable)e);
            }
        }));
        lanceRESTServer.join();
        LOG.info("Shutting down Gravitino Lance REST Server ... ");
        try {
            lanceRESTServer.stop();
            LOG.info("Gravitino Lance REST Server has shut down.");
        }
        catch (Exception e) {
            LOG.error("Error while stopping Gravitino Lance REST Server", (Throwable)e);
        }
    }
}

