/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.stats;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.dto.AuditDTO;
import org.apache.gravitino.json.JsonUtils;
import org.apache.gravitino.stats.Statistic;
import org.apache.gravitino.stats.StatisticValue;

public class StatisticDTO
implements Statistic {
    @JsonProperty(value="name")
    private String name;
    @Nullable
    @JsonInclude
    @JsonProperty(value="value")
    @JsonSerialize(using=JsonUtils.StatisticValueSerializer.class)
    @JsonDeserialize(using=JsonUtils.StatisticValueDeserializer.class)
    private StatisticValue<?> value;
    @JsonProperty(value="reserved")
    private boolean reserved;
    @JsonProperty(value="modifiable")
    private boolean modifiable;
    @JsonProperty(value="audit")
    private AuditDTO audit;

    public String name() {
        return this.name;
    }

    public Optional<StatisticValue<?>> value() {
        return Optional.ofNullable(this.value);
    }

    public boolean reserved() {
        return this.reserved;
    }

    public boolean modifiable() {
        return this.modifiable;
    }

    public void validate() {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.name), (Object)"\"name\" is required and cannot be empty");
        Preconditions.checkArgument((this.audit != null ? 1 : 0) != 0, (Object)"\"audit\" information is required and cannot be null");
    }

    public AuditDTO auditInfo() {
        return this.audit;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StatisticDTO)) {
            return false;
        }
        StatisticDTO other = (StatisticDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.reserved != other.reserved) {
            return false;
        }
        if (this.modifiable != other.modifiable) {
            return false;
        }
        String this$name = this.name;
        String other$name = other.name;
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        StatisticValue<?> this$value = this.value;
        StatisticValue<?> other$value = other.value;
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        AuditDTO this$audit = this.audit;
        AuditDTO other$audit = other.audit;
        return !(this$audit == null ? other$audit != null : !((Object)this$audit).equals(other$audit));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StatisticDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.reserved ? 79 : 97);
        result = result * 59 + (this.modifiable ? 79 : 97);
        String $name = this.name;
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        StatisticValue<?> $value = this.value;
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        AuditDTO $audit = this.audit;
        result = result * 59 + ($audit == null ? 43 : ((Object)$audit).hashCode());
        return result;
    }

    public String toString() {
        return "StatisticDTO(name=" + this.name + ", value=" + String.valueOf(this.value) + ", reserved=" + this.reserved + ", modifiable=" + this.modifiable + ", audit=" + String.valueOf(this.audit) + ")";
    }

    public static class Builder {
        private String name;
        private StatisticValue<?> value;
        private boolean reserved;
        private boolean modifiable;
        private AuditDTO audit;

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withValue(Optional<StatisticValue<?>> value) {
            value.ifPresent(v -> {
                this.value = v;
            });
            return this;
        }

        public Builder withReserved(boolean reserved) {
            this.reserved = reserved;
            return this;
        }

        public Builder withModifiable(boolean modifiable) {
            this.modifiable = modifiable;
            return this;
        }

        public Builder withAudit(AuditDTO audit) {
            this.audit = audit;
            return this;
        }

        public StatisticDTO build() {
            StatisticDTO statisticDTO = new StatisticDTO();
            statisticDTO.name = this.name;
            statisticDTO.value = this.value;
            statisticDTO.reserved = this.reserved;
            statisticDTO.modifiable = this.modifiable;
            statisticDTO.audit = this.audit;
            statisticDTO.validate();
            return statisticDTO;
        }
    }
}

