/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.rel;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Preconditions;
import org.apache.gravitino.dto.rel.ColumnDTO;
import org.apache.gravitino.dto.rel.expressions.FunctionArg;
import org.apache.gravitino.json.JsonUtils;
import org.apache.gravitino.rel.expressions.Expression;
import org.apache.gravitino.rel.expressions.sorts.NullOrdering;
import org.apache.gravitino.rel.expressions.sorts.SortDirection;
import org.apache.gravitino.rel.expressions.sorts.SortOrder;

@JsonSerialize(using=JsonUtils.SortOrderSerializer.class)
@JsonDeserialize(using=JsonUtils.SortOrderDeserializer.class)
public class SortOrderDTO
implements SortOrder {
    public static final SortOrderDTO[] EMPTY_SORT = new SortOrderDTO[0];
    private final FunctionArg sortTerm;
    private final SortDirection direction;
    private final NullOrdering nullOrdering;

    private SortOrderDTO(FunctionArg sortTerm, SortDirection direction, NullOrdering nullOrdering) {
        this.sortTerm = sortTerm;
        this.direction = direction;
        this.nullOrdering = nullOrdering;
    }

    public FunctionArg sortTerm() {
        return this.sortTerm;
    }

    public Expression expression() {
        return this.sortTerm;
    }

    public SortDirection direction() {
        return this.direction;
    }

    public NullOrdering nullOrdering() {
        return this.nullOrdering;
    }

    public void validate(ColumnDTO[] columns) throws IllegalArgumentException {
        this.sortTerm.validate(columns);
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SortOrderDTO)) {
            return false;
        }
        SortOrderDTO other = (SortOrderDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        FunctionArg this$sortTerm = this.sortTerm;
        FunctionArg other$sortTerm = other.sortTerm;
        if (this$sortTerm == null ? other$sortTerm != null : !this$sortTerm.equals(other$sortTerm)) {
            return false;
        }
        SortDirection this$direction = this.direction;
        SortDirection other$direction = other.direction;
        if (this$direction == null ? other$direction != null : !this$direction.equals(other$direction)) {
            return false;
        }
        NullOrdering this$nullOrdering = this.nullOrdering;
        NullOrdering other$nullOrdering = other.nullOrdering;
        return !(this$nullOrdering == null ? other$nullOrdering != null : !this$nullOrdering.equals(other$nullOrdering));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SortOrderDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FunctionArg $sortTerm = this.sortTerm;
        result = result * 59 + ($sortTerm == null ? 43 : $sortTerm.hashCode());
        SortDirection $direction = this.direction;
        result = result * 59 + ($direction == null ? 43 : $direction.hashCode());
        NullOrdering $nullOrdering = this.nullOrdering;
        result = result * 59 + ($nullOrdering == null ? 43 : $nullOrdering.hashCode());
        return result;
    }

    public static class Builder {
        private FunctionArg sortTerm;
        private SortDirection direction;
        private NullOrdering nullOrdering;

        private Builder() {
        }

        public Builder withSortTerm(FunctionArg sortTerm) {
            this.sortTerm = sortTerm;
            return this;
        }

        public Builder withDirection(SortDirection direction) {
            this.direction = direction;
            return this;
        }

        public Builder withNullOrder(NullOrdering nullOrdering) {
            this.nullOrdering = nullOrdering;
            return this;
        }

        public SortOrderDTO build() {
            this.direction = this.direction == null ? SortDirection.ASCENDING : this.direction;
            this.nullOrdering = this.nullOrdering == null ? this.direction.defaultNullOrdering() : this.nullOrdering;
            Preconditions.checkArgument((this.sortTerm != null ? 1 : 0) != 0, (Object)"expression cannot be null");
            return new SortOrderDTO(this.sortTerm, this.direction, this.nullOrdering);
        }
    }
}

