/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.util;

import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.raft.jraft.util.HeapByteBufUtil;

public class Bits {
    public static int getInt(byte[] b, int off) {
        return HeapByteBufUtil.getInt(b, off);
    }

    public static long getLong(byte[] b, int off) {
        return HeapByteBufUtil.getLong(b, off);
    }

    public static void putInt(byte[] b, int off, int val) {
        HeapByteBufUtil.setInt(b, off, val);
    }

    public static void putShort(byte[] b, int off, short val) {
        HeapByteBufUtil.setShort(b, off, val);
    }

    public static short getShort(byte[] b, int off) {
        return HeapByteBufUtil.getShort(b, off);
    }

    public static void putLong(byte[] b, int off, long val) {
        HeapByteBufUtil.setLong(b, off, val);
    }

    public static void putShortLittleEndian(long addr, short value) {
        if (GridUnsafe.IS_BIG_ENDIAN) {
            GridUnsafe.putShort((long)addr, (short)Short.reverseBytes(value));
        } else {
            GridUnsafe.putShort((long)addr, (short)value);
        }
    }

    public static void putShortLittleEndian(byte[] b, int off, short value) {
        if (GridUnsafe.IS_BIG_ENDIAN) {
            GridUnsafe.putShort((byte[])b, (long)(GridUnsafe.BYTE_ARR_OFF + (long)off), (short)Short.reverseBytes(value));
        } else {
            GridUnsafe.putShort((byte[])b, (long)(GridUnsafe.BYTE_ARR_OFF + (long)off), (short)value);
        }
    }

    public static short getShortLittleEndian(byte[] b, int off) {
        short value = GridUnsafe.getShort((byte[])b, (long)(GridUnsafe.BYTE_ARR_OFF + (long)off));
        return GridUnsafe.IS_BIG_ENDIAN ? Short.reverseBytes(value) : value;
    }

    public static void putIntLittleEndian(long addr, int value) {
        if (GridUnsafe.IS_BIG_ENDIAN) {
            GridUnsafe.putInt((long)addr, (int)Integer.reverseBytes(value));
        } else {
            GridUnsafe.putInt((long)addr, (int)value);
        }
    }

    public static void putLongLittleEndian(long addr, long value) {
        if (GridUnsafe.IS_BIG_ENDIAN) {
            GridUnsafe.putLong((long)addr, (long)Long.reverseBytes(value));
        } else {
            GridUnsafe.putLong((long)addr, (long)value);
        }
    }

    public static void putLongLittleEndian(byte[] b, int off, long value) {
        if (GridUnsafe.IS_BIG_ENDIAN) {
            GridUnsafe.putLong((byte[])b, (long)(GridUnsafe.BYTE_ARR_OFF + (long)off), (long)Long.reverseBytes(value));
        } else {
            GridUnsafe.putLong((byte[])b, (long)(GridUnsafe.BYTE_ARR_OFF + (long)off), (long)value);
        }
    }

    public static long getLongLittleEndian(byte[] b, int off) {
        long value = GridUnsafe.getLong((byte[])b, (long)(GridUnsafe.BYTE_ARR_OFF + (long)off));
        return GridUnsafe.IS_BIG_ENDIAN ? Long.reverseBytes(value) : value;
    }
}

