/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client.handler.requests.sql;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.ignite.client.handler.ClientResourceRegistry;
import org.apache.ignite.client.handler.ResponseWriter;
import org.apache.ignite.client.handler.requests.sql.ClientSqlCommon;
import org.apache.ignite.client.handler.requests.table.ClientTableCommon;
import org.apache.ignite.internal.client.proto.ClientMessagePacker;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.hlc.HybridTimestampTracker;
import org.apache.ignite.internal.sql.engine.QueryProcessor;
import org.apache.ignite.internal.sql.engine.SqlProperties;
import org.apache.ignite.internal.sql.engine.prepare.ParameterType;
import org.apache.ignite.internal.sql.engine.prepare.QueryMetadata;
import org.apache.ignite.internal.tx.InternalTransaction;
import org.apache.ignite.internal.util.CompletableFutures;

public class ClientSqlQueryMetadataRequest {
    public static CompletableFuture<ResponseWriter> process(Executor operationExecutor, ClientMessageUnpacker in, QueryProcessor processor, ClientResourceRegistry resources, HybridTimestampTracker tsTracker) {
        InternalTransaction tx = ClientTableCommon.readTx(in, tsTracker, resources, null, null, null);
        String schema = in.unpackString();
        String query = in.unpackString();
        SqlProperties properties = new SqlProperties().defaultSchema(schema);
        return CompletableFutures.nullCompletedFuture().thenComposeAsync(none -> processor.prepareSingleAsync(properties, tx, query, new Object[0]).thenApply(meta -> out -> ClientSqlQueryMetadataRequest.writeMeta(out, meta)), operationExecutor);
    }

    private static void writeMeta(ClientMessagePacker out, QueryMetadata meta) {
        List types = meta.parameterTypes();
        out.packInt(types.size());
        for (ParameterType param : types) {
            out.packBoolean(param.nullable());
            out.packInt(param.columnType().id());
            out.packInt(param.scale());
            out.packInt(param.precision());
        }
        ClientSqlCommon.packColumns(out, meta.columns());
    }
}

