/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.network.ChannelType;
import org.apache.ignite.internal.network.InternalClusterNode;
import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.network.NetworkMessageHandler;
import org.apache.ignite.internal.thread.ExecutorChooser;
import org.apache.ignite.network.NetworkAddress;

public interface MessagingService {
    public void weakSend(InternalClusterNode var1, NetworkMessage var2);

    default public CompletableFuture<Void> send(InternalClusterNode recipient, NetworkMessage msg) {
        return this.send(recipient, ChannelType.DEFAULT, msg);
    }

    public CompletableFuture<Void> send(InternalClusterNode var1, ChannelType var2, NetworkMessage var3);

    public CompletableFuture<Void> send(String var1, ChannelType var2, NetworkMessage var3);

    public CompletableFuture<Void> send(NetworkAddress var1, ChannelType var2, NetworkMessage var3);

    default public CompletableFuture<Void> respond(InternalClusterNode recipient, NetworkMessage msg, long correlationId) {
        return this.respond(recipient, ChannelType.DEFAULT, msg, correlationId);
    }

    public CompletableFuture<Void> respond(InternalClusterNode var1, ChannelType var2, NetworkMessage var3, long var4);

    default public CompletableFuture<Void> respond(String recipientConsistentId, NetworkMessage msg, long correlationId) {
        return this.respond(recipientConsistentId, ChannelType.DEFAULT, msg, correlationId);
    }

    public CompletableFuture<Void> respond(String var1, ChannelType var2, NetworkMessage var3, long var4);

    default public CompletableFuture<NetworkMessage> invoke(InternalClusterNode recipient, NetworkMessage msg, long timeout) {
        return this.invoke(recipient, ChannelType.DEFAULT, msg, timeout);
    }

    public CompletableFuture<NetworkMessage> invoke(InternalClusterNode var1, ChannelType var2, NetworkMessage var3, long var4);

    default public CompletableFuture<NetworkMessage> invoke(String recipientConsistentId, NetworkMessage msg, long timeout) {
        return this.invoke(recipientConsistentId, ChannelType.DEFAULT, msg, timeout);
    }

    public CompletableFuture<NetworkMessage> invoke(String var1, ChannelType var2, NetworkMessage var3, long var4);

    public void addMessageHandler(Class<?> var1, NetworkMessageHandler var2);

    public void addMessageHandler(Class<?> var1, ExecutorChooser<NetworkMessage> var2, NetworkMessageHandler var3);
}

