/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.node;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.SingleChildProcessNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.OrderingScheme;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.Measure;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.RowsPerMatch;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.SkipToPosition;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.ExpressionAndValuePointers;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrLabel;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrRowPattern;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class PatternRecognitionNode
extends SingleChildProcessNode {
    private final List<Symbol> partitionBy;
    private final Optional<OrderingScheme> orderingScheme;
    private final Optional<Symbol> hashSymbol;
    private final Map<Symbol, Measure> measures;
    private final RowsPerMatch rowsPerMatch;
    private final Set<IrLabel> skipToLabels;
    private final SkipToPosition skipToPosition;
    private final IrRowPattern pattern;
    private final Map<IrLabel, ExpressionAndValuePointers> variableDefinitions;

    public PatternRecognitionNode(PlanNodeId id, PlanNode child, List<Symbol> partitionBy, Optional<OrderingScheme> orderingScheme, Optional<Symbol> hashSymbol, Map<Symbol, Measure> measures, RowsPerMatch rowsPerMatch, Set<IrLabel> skipToLabels, SkipToPosition skipToPosition, IrRowPattern pattern, Map<IrLabel, ExpressionAndValuePointers> variableDefinitions) {
        super(id, child);
        this.partitionBy = Objects.requireNonNull(partitionBy, "partitionBy is null");
        this.orderingScheme = Objects.requireNonNull(orderingScheme, "orderingScheme is null");
        this.hashSymbol = Objects.requireNonNull(hashSymbol, "hashSymbol is null");
        this.measures = Objects.requireNonNull(measures, "measures is null");
        this.rowsPerMatch = Objects.requireNonNull(rowsPerMatch, "rowsPerMatch is null");
        this.skipToLabels = Objects.requireNonNull(skipToLabels, "skipToLabels is null");
        this.skipToPosition = Objects.requireNonNull(skipToPosition, "skipToPosition is null");
        this.pattern = Objects.requireNonNull(pattern, "pattern is null");
        this.variableDefinitions = Objects.requireNonNull(variableDefinitions, "variableDefinitions is null");
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        ImmutableList.Builder outputSymbols = ImmutableList.builder();
        if (this.rowsPerMatch == RowsPerMatch.ONE) {
            outputSymbols.addAll(this.partitionBy);
        } else {
            outputSymbols.addAll(this.child.getOutputSymbols());
        }
        outputSymbols.addAll(this.measures.keySet());
        return outputSymbols.build();
    }

    public Set<Symbol> getCreatedSymbols() {
        return ImmutableSet.copyOf(this.measures.keySet());
    }

    public List<Symbol> getPartitionBy() {
        return this.partitionBy;
    }

    public Optional<OrderingScheme> getOrderingScheme() {
        return this.orderingScheme;
    }

    public Optional<Symbol> getHashSymbol() {
        return this.hashSymbol;
    }

    public Map<Symbol, Measure> getMeasures() {
        return this.measures;
    }

    public RowsPerMatch getRowsPerMatch() {
        return this.rowsPerMatch;
    }

    public Set<IrLabel> getSkipToLabels() {
        return this.skipToLabels;
    }

    public SkipToPosition getSkipToPosition() {
        return this.skipToPosition;
    }

    public IrRowPattern getPattern() {
        return this.pattern;
    }

    public Map<IrLabel, ExpressionAndValuePointers> getVariableDefinitions() {
        return this.variableDefinitions;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitPatternRecognition(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new PatternRecognitionNode(this.id, (PlanNode)Iterables.getOnlyElement(newChildren), this.partitionBy, this.orderingScheme, this.hashSymbol, this.measures, this.rowsPerMatch, this.skipToLabels, this.skipToPosition, this.pattern, this.variableDefinitions);
    }

    @Override
    public PlanNode clone() {
        return new PatternRecognitionNode(this.id, null, this.partitionBy, this.orderingScheme, this.hashSymbol, this.measures, this.rowsPerMatch, this.skipToLabels, this.skipToPosition, this.pattern, this.variableDefinitions);
    }

    @Override
    public List<String> getOutputColumnNames() {
        return null;
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.TABLE_PATTERN_RECOGNITION_NODE.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.partitionBy.size(), (ByteBuffer)byteBuffer);
        for (Symbol symbol : this.partitionBy) {
            Symbol.serialize(symbol, byteBuffer);
        }
        if (this.orderingScheme.isPresent()) {
            ReadWriteIOUtils.write((Boolean)true, (ByteBuffer)byteBuffer);
            this.orderingScheme.get().serialize(byteBuffer);
        } else {
            ReadWriteIOUtils.write((Boolean)false, (ByteBuffer)byteBuffer);
        }
        if (this.hashSymbol.isPresent()) {
            ReadWriteIOUtils.write((Boolean)true, (ByteBuffer)byteBuffer);
            Symbol.serialize(this.hashSymbol.get(), byteBuffer);
        } else {
            ReadWriteIOUtils.write((Boolean)false, (ByteBuffer)byteBuffer);
        }
        ReadWriteIOUtils.write((int)this.measures.size(), (ByteBuffer)byteBuffer);
        for (Map.Entry entry : this.measures.entrySet()) {
            Symbol.serialize((Symbol)entry.getKey(), byteBuffer);
            Measure.serialize((Measure)entry.getValue(), byteBuffer);
        }
        RowsPerMatch.serialize(this.rowsPerMatch, byteBuffer);
        ReadWriteIOUtils.write((int)this.skipToLabels.size(), (ByteBuffer)byteBuffer);
        for (IrLabel irLabel : this.skipToLabels) {
            IrLabel.serialize(irLabel, byteBuffer);
        }
        SkipToPosition.serialize(this.skipToPosition, byteBuffer);
        IrRowPattern.serialize(this.pattern, byteBuffer);
        ReadWriteIOUtils.write((int)this.variableDefinitions.size(), (ByteBuffer)byteBuffer);
        for (Map.Entry entry : this.variableDefinitions.entrySet()) {
            IrLabel.serialize((IrLabel)entry.getKey(), byteBuffer);
            ExpressionAndValuePointers.serialize((ExpressionAndValuePointers)entry.getValue(), byteBuffer);
        }
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.TABLE_PATTERN_RECOGNITION_NODE.serialize(stream);
        ReadWriteIOUtils.write((int)this.partitionBy.size(), (OutputStream)stream);
        for (Symbol symbol : this.partitionBy) {
            Symbol.serialize(symbol, stream);
        }
        if (this.orderingScheme.isPresent()) {
            ReadWriteIOUtils.write((Boolean)true, (OutputStream)stream);
            this.orderingScheme.get().serialize(stream);
        } else {
            ReadWriteIOUtils.write((Boolean)false, (OutputStream)stream);
        }
        if (this.hashSymbol.isPresent()) {
            ReadWriteIOUtils.write((Boolean)true, (OutputStream)stream);
            Symbol.serialize(this.hashSymbol.get(), stream);
        } else {
            ReadWriteIOUtils.write((Boolean)false, (OutputStream)stream);
        }
        ReadWriteIOUtils.write((int)this.measures.size(), (OutputStream)stream);
        for (Map.Entry entry : this.measures.entrySet()) {
            Symbol.serialize((Symbol)entry.getKey(), stream);
            Measure.serialize((Measure)entry.getValue(), stream);
        }
        RowsPerMatch.serialize(this.rowsPerMatch, stream);
        ReadWriteIOUtils.write((int)this.skipToLabels.size(), (OutputStream)stream);
        for (IrLabel irLabel : this.skipToLabels) {
            IrLabel.serialize(irLabel, stream);
        }
        SkipToPosition.serialize(this.skipToPosition, stream);
        IrRowPattern.serialize(this.pattern, stream);
        ReadWriteIOUtils.write((int)this.variableDefinitions.size(), (OutputStream)stream);
        for (Map.Entry entry : this.variableDefinitions.entrySet()) {
            IrLabel.serialize((IrLabel)entry.getKey(), stream);
            ExpressionAndValuePointers.serialize((ExpressionAndValuePointers)entry.getValue(), stream);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PatternRecognitionNode that = (PatternRecognitionNode)o;
        return Objects.equals(this.partitionBy, that.partitionBy) && Objects.equals(this.orderingScheme, that.orderingScheme) && Objects.equals(this.hashSymbol, that.hashSymbol) && Objects.equals(this.measures, that.measures) && this.rowsPerMatch == that.rowsPerMatch && Objects.equals(this.skipToLabels, that.skipToLabels) && this.skipToPosition == that.skipToPosition && Objects.equals(this.pattern, that.pattern) && Objects.equals(this.variableDefinitions, that.variableDefinitions);
    }

    public static PatternRecognitionNode deserialize(ByteBuffer byteBuffer) {
        int partitionSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        ImmutableList.Builder partitionByBuilder = ImmutableList.builder();
        for (int i = 0; i < partitionSize; ++i) {
            partitionByBuilder.add((Object)Symbol.deserialize(byteBuffer));
        }
        ImmutableList partitionBy = partitionByBuilder.build();
        Optional<OrderingScheme> orderingScheme = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer) ? Optional.of(OrderingScheme.deserialize(byteBuffer)) : Optional.empty();
        Optional<Symbol> hashSymbol = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer) ? Optional.of(Symbol.deserialize(byteBuffer)) : Optional.empty();
        int measureSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        ImmutableMap.Builder measuresBuilder = ImmutableMap.builder();
        for (int i = 0; i < measureSize; ++i) {
            Symbol key = Symbol.deserialize(byteBuffer);
            Measure value = Measure.deserialize(byteBuffer);
            measuresBuilder.put((Object)key, (Object)value);
        }
        ImmutableMap measures = measuresBuilder.build();
        RowsPerMatch rowsPerMatch = RowsPerMatch.deserialize(byteBuffer);
        int skipToLabelSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        ImmutableSet.Builder skipToLabelBuilder = ImmutableSet.builder();
        for (int i = 0; i < skipToLabelSize; ++i) {
            skipToLabelBuilder.add((Object)IrLabel.deserialize(byteBuffer));
        }
        ImmutableSet skipToLabels = skipToLabelBuilder.build();
        SkipToPosition skipToPosition = SkipToPosition.deserialize(byteBuffer);
        IrRowPattern pattern = IrRowPattern.deserialize(byteBuffer);
        int varDefSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        ImmutableMap.Builder varDefBuilder = ImmutableMap.builder();
        for (int i = 0; i < varDefSize; ++i) {
            IrLabel label = IrLabel.deserialize(byteBuffer);
            ExpressionAndValuePointers expr = ExpressionAndValuePointers.deserialize(byteBuffer);
            varDefBuilder.put((Object)label, (Object)expr);
        }
        ImmutableMap variableDefinitions = varDefBuilder.build();
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new PatternRecognitionNode(planNodeId, null, (List<Symbol>)partitionBy, orderingScheme, hashSymbol, (Map<Symbol, Measure>)measures, rowsPerMatch, (Set<IrLabel>)skipToLabels, skipToPosition, pattern, (Map<IrLabel, ExpressionAndValuePointers>)variableDefinitions);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.partitionBy, this.orderingScheme, this.hashSymbol, this.measures, this.rowsPerMatch, this.skipToLabels, this.skipToPosition, this.pattern, this.variableDefinitions});
    }

    public String toString() {
        return "PatternRecognitionNode-" + this.getPlanNodeId();
    }
}

