/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.evaluator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.filter.ExprNode;
import org.apache.directory.api.ldap.model.filter.OrNode;
import org.apache.directory.server.core.api.partition.PartitionTxn;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.search.Evaluator;
import org.apache.directory.server.xdbm.search.impl.ScanCountComparator;

public class OrEvaluator
implements Evaluator<OrNode> {
    private final List<Evaluator<? extends ExprNode>> evaluators;
    private final OrNode node;

    public OrEvaluator(OrNode node, List<Evaluator<? extends ExprNode>> evaluators) {
        this.node = node;
        this.evaluators = this.optimize(evaluators);
    }

    private List<Evaluator<? extends ExprNode>> optimize(List<Evaluator<? extends ExprNode>> unoptimized) {
        ArrayList<Evaluator<? extends ExprNode>> optimized = new ArrayList<Evaluator<? extends ExprNode>>(unoptimized.size());
        optimized.addAll(unoptimized);
        Collections.sort(optimized, new ScanCountComparator());
        return optimized;
    }

    @Override
    public boolean evaluate(PartitionTxn partitionTxn, IndexEntry<?, String> indexEntry) throws LdapException {
        for (Evaluator<? extends ExprNode> evaluator : this.evaluators) {
            if (!evaluator.evaluate(partitionTxn, indexEntry)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean evaluate(Entry entry) throws LdapException {
        for (Evaluator<? extends ExprNode> evaluator : this.evaluators) {
            if (!evaluator.evaluate(entry)) continue;
            return true;
        }
        return false;
    }

    @Override
    public OrNode getExpression() {
        return this.node;
    }

    private String dumpEvaluators(String tabs) {
        StringBuilder sb = new StringBuilder();
        for (Evaluator<? extends ExprNode> evaluator : this.evaluators) {
            sb.append(evaluator.toString(tabs + "  "));
        }
        return sb.toString();
    }

    @Override
    public String toString(String tabs) {
        StringBuilder sb = new StringBuilder();
        sb.append(tabs).append("OrEvaluator : ").append(this.node).append("\n");
        if (this.evaluators != null && !this.evaluators.isEmpty()) {
            sb.append(this.dumpEvaluators(tabs));
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString("");
    }
}

