/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.component;

import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectOne;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.SupportsAutoSpacing;
import org.apache.myfaces.tobago.component.SupportsDecorationPosition;
import org.apache.myfaces.tobago.component.SupportsHelp;
import org.apache.myfaces.tobago.component.SupportsLabelLayout;
import org.apache.myfaces.tobago.component.Visual;
import org.apache.myfaces.tobago.util.MessageUtils;

public abstract class AbstractUISelectOneBase
extends UISelectOne
implements SupportsAutoSpacing,
Visual,
SupportsLabelLayout,
ClientBehaviorHolder,
SupportsHelp,
SupportsDecorationPosition {
    public static final String MESSAGE_VALUE_REQUIRED = "org.apache.myfaces.tobago.UISelectOne.REQUIRED";
    private transient boolean nextToRenderIsLabel;

    public void validate(FacesContext facesContext) {
        Object submittedValue;
        if (this.isRequired() && !this.isReadonly() && !this.isDisabled() && ((submittedValue = this.getSubmittedValue()) == null || "".equals(submittedValue))) {
            if (this.getRequiredMessage() != null) {
                String requiredMessage = this.getRequiredMessage();
                facesContext.addMessage(this.getClientId(facesContext), new FacesMessage(FacesMessage.SEVERITY_ERROR, requiredMessage, requiredMessage));
            } else {
                facesContext.addMessage(this.getClientId(facesContext), MessageUtils.getMessage(facesContext, FacesMessage.SEVERITY_ERROR, MESSAGE_VALUE_REQUIRED, MessageUtils.getLabel(facesContext, (UIComponent)this)));
            }
            this.setValid(false);
        }
        super.validate(facesContext);
    }

    public abstract boolean isReadonly();

    public abstract boolean isDisabled();

    public boolean isError() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return !this.isValid() || !facesContext.getMessageList(this.getClientId(facesContext)).isEmpty();
    }

    public abstract boolean isFocus();

    public abstract Integer getTabIndex();

    @Override
    public boolean isNextToRenderIsLabel() {
        return this.nextToRenderIsLabel;
    }

    @Override
    public void setNextToRenderIsLabel(boolean nextToRenderIsLabel) {
        this.nextToRenderIsLabel = nextToRenderIsLabel;
    }
}

