/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ComponentSystemEventListener;
import javax.faces.event.ListenerFor;
import javax.faces.event.PostAddToViewEvent;
import org.apache.myfaces.tobago.component.SupportFieldId;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.component.AbstractUILabel;
import org.apache.myfaces.tobago.internal.util.AccessKeyLogger;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.renderkit.LabelWithAccessKey;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

@ListenerFor(systemEventClass=PostAddToViewEvent.class)
public class LabelRenderer<T extends AbstractUILabel>
extends RendererBase<T>
implements ComponentSystemEventListener {
    public void processEvent(ComponentSystemEvent event) {
        ComponentUtils.evaluateAutoFor(event.getComponent(), UIInput.class);
    }

    @Override
    public void encodeEndInternal(FacesContext facesContext, T component) throws IOException {
        String title;
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        UIComponent corresponding = ComponentUtils.findFor(component);
        String forId = corresponding instanceof SupportFieldId ? ((SupportFieldId)corresponding).getFieldId(facesContext) : (corresponding != null ? corresponding.getClientId(facesContext) : null);
        String clientId = component.getClientId(facesContext);
        Markup markup = component.getMarkup();
        boolean required = corresponding instanceof UIInput ? ((UIInput)corresponding).isRequired() : false;
        writer.startElement(HtmlElements.LABEL);
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, component);
        writer.writeClassAttribute(BootstrapClass.COL_FORM_LABEL, required ? TobagoClass.REQUIRED : null, component.getCustomClass());
        writer.writeIdAttribute(clientId);
        if (forId != null) {
            writer.writeAttribute(HtmlAttributes.FOR, forId, false);
        }
        if ((title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, component)) != null) {
            writer.writeAttribute(HtmlAttributes.TITLE, title, true);
        }
        this.encodeTextContent(facesContext, writer, (AbstractUILabel)component);
        writer.endElement(HtmlElements.LABEL);
    }

    protected void encodeTextContent(FacesContext facesContext, TobagoResponseWriter writer, AbstractUILabel component) throws IOException {
        LabelWithAccessKey label = new LabelWithAccessKey(component);
        if (label.getAccessKey() != null) {
            writer.writeAttribute(HtmlAttributes.ACCESSKEY, Character.toString(label.getAccessKey().charValue()), false);
            AccessKeyLogger.addAccessKey(facesContext, label.getAccessKey(), component.getClientId());
        }
        HtmlRendererUtils.writeLabelWithAccessKey(writer, label);
    }
}

