/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import jakarta.faces.component.behavior.ClientBehaviorHolder;
import jakarta.faces.context.FacesContext;
import java.io.IOException;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.component.AbstractUICollapsiblePanel;
import org.apache.myfaces.tobago.internal.component.AbstractUIPanel;
import org.apache.myfaces.tobago.internal.component.AbstractUIPanelBase;
import org.apache.myfaces.tobago.internal.component.AbstractUIReload;
import org.apache.myfaces.tobago.internal.renderkit.renderer.CollapsiblePanelRendererBase;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.model.CollapseMode;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class PanelRenderer<T extends AbstractUIPanel>
extends CollapsiblePanelRendererBase<T> {
    @Override
    public void encodeBeginInternal(FacesContext facesContext, T component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        String clientId = component.getClientId(facesContext);
        boolean collapsed = ((AbstractUICollapsiblePanel)component).isCollapsed();
        Markup markup = component.getMarkup();
        AbstractUIReload reload = ComponentUtils.getReloadFacet(component);
        writer.startElement(HtmlElements.TOBAGO_PANEL);
        writer.writeIdAttribute(clientId);
        writer.writeClassAttribute(collapsed ? TobagoClass.COLLAPSED : null, component.getCustomClass(), markup != null && markup.contains(Markup.SPREAD) ? TobagoClass.SPREAD : null);
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, component);
        String tip = ((AbstractUIPanelBase)component).getTip();
        if (tip != null) {
            writer.writeAttribute(HtmlAttributes.TITLE, tip, true);
        }
        if (((AbstractUICollapsiblePanel)component).getCollapsedMode() != CollapseMode.none) {
            this.encodeHidden(writer, clientId, collapsed);
        }
        this.encodeBehavior(writer, facesContext, (ClientBehaviorHolder)component);
        if (reload != null) {
            reload.encodeAll(facesContext);
        }
    }

    @Override
    public void encodeEndInternal(FacesContext facesContext, T component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.endElement(HtmlElements.TOBAGO_PANEL);
    }
}

