/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.render.CoreRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.SpecialColumnRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.TableRenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.TableSelectManyRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.TableSelectOneRenderer;

public class SelectionColumnRenderer
extends SpecialColumnRenderer {
    private final CoreRenderer _singleRenderer;
    private final CoreRenderer _multiRenderer;

    public SelectionColumnRenderer(FacesBean.Type tableType) {
        this._singleRenderer = new TableSelectOneRenderer(tableType);
        this._multiRenderer = new TableSelectManyRenderer(tableType);
    }

    protected void renderKids(FacesContext context, RenderingContext arc, TableRenderingContext trc, UIComponent column) throws IOException {
        UIComponent table = trc.getTable();
        this.delegateRenderer(context, arc, table, this.getFacesBean(table), trc.hasSelectAll() ? this._multiRenderer : this._singleRenderer);
    }

    protected String getHeaderText(FacesBean bean) {
        RenderingContext arc = RenderingContext.getCurrentInstance();
        TableRenderingContext tContext = TableRenderingContext.getCurrentInstance();
        String key = SelectionColumnRenderer._isMultipleSelection(tContext) ? "af_tableSelectMany.SELECT_COLUMN_HEADER" : "af_tableSelectOne.SELECT_COLUMN_HEADER";
        return arc.getTranslatedString(key);
    }

    protected boolean getNoWrap(FacesBean bean) {
        return false;
    }

    protected String getFormatType(FacesBean bean) {
        return "center";
    }

    protected String getHeaderStyleClass(TableRenderingContext tContext) {
        return "af|column::header-icon-format";
    }

    private static boolean _isMultipleSelection(TableRenderingContext tContext) {
        return tContext.hasSelectAll();
    }
}

