/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.image.xml.parse;

import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.share.xml.ParseContext;
import org.apache.myfaces.trinidadinternal.share.xml.ParseErrorUtils;
import org.xml.sax.Attributes;

public class ImageParseUtils {
    private static final String _INT_ERROR = "Error while parsing integer attribute value.";
    private static final String _BOOLEAN_ERROR = "Error while parsing boolean attribute value.";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(ImageParseUtils.class);

    public static Boolean getBooleanAttributeValue(ParseContext context, Attributes attrs, String localName) {
        String value = attrs.getValue(localName);
        if (value == null) {
            return null;
        }
        if ("true".equalsIgnoreCase(value)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(value)) {
            return Boolean.FALSE;
        }
        String message = ParseErrorUtils.getErrorMessage(context, _BOOLEAN_ERROR);
        if (_LOG.isWarning()) {
            _LOG.warning(message);
        }
        return null;
    }

    public static Integer getIntegerAttributeValue(ParseContext context, Attributes attrs, String localName) {
        String value = attrs.getValue(localName);
        if (value == null) {
            return null;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            String message = ParseErrorUtils.getErrorMessage(context, _INT_ERROR);
            if (_LOG.isWarning()) {
                _LOG.warning(message);
            }
            return null;
        }
    }

    private ImageParseUtils() {
    }
}

