/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.client.impl;

import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.MediaType;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.toolkit.client.NiFiClientException;
import org.apache.nifi.toolkit.client.ProvenanceClient;
import org.apache.nifi.toolkit.client.RequestConfig;
import org.apache.nifi.toolkit.client.impl.AbstractJerseyClient;
import org.apache.nifi.web.api.entity.LatestProvenanceEventsEntity;
import org.apache.nifi.web.api.entity.LineageEntity;
import org.apache.nifi.web.api.entity.ProvenanceEntity;
import org.apache.nifi.web.api.entity.ReplayLastEventRequestEntity;
import org.apache.nifi.web.api.entity.ReplayLastEventResponseEntity;

public class JerseyProvenanceClient
extends AbstractJerseyClient
implements ProvenanceClient {
    private final WebTarget provenanceTarget;
    private final WebTarget provenanceEventsTarget;

    public JerseyProvenanceClient(WebTarget baseTarget) {
        this(baseTarget, null);
    }

    public JerseyProvenanceClient(WebTarget baseTarget, RequestConfig requestConfig) {
        super(requestConfig);
        this.provenanceTarget = baseTarget.path("/provenance");
        this.provenanceEventsTarget = baseTarget.path("/provenance-events");
    }

    @Override
    public ProvenanceEntity submitProvenanceQuery(ProvenanceEntity provenanceEntity) throws NiFiClientException, IOException {
        if (provenanceEntity == null) {
            throw new IllegalArgumentException("Provenance entity cannot be null");
        }
        return this.executeAction("Error submitting Provenance Query", () -> (ProvenanceEntity)this.getRequestBuilder(this.provenanceTarget).post(Entity.entity((Object)provenanceEntity, (MediaType)MediaType.APPLICATION_JSON_TYPE), ProvenanceEntity.class));
    }

    @Override
    public ProvenanceEntity getProvenanceQuery(String queryId) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)queryId)) {
            throw new IllegalArgumentException("Query ID cannot be null");
        }
        return this.executeAction("Error retrieving status of Provenance Query", () -> {
            WebTarget target = this.provenanceTarget.path("/{id}").resolveTemplate("id", (Object)queryId);
            return (ProvenanceEntity)this.getRequestBuilder(target).get(ProvenanceEntity.class);
        });
    }

    @Override
    public ProvenanceEntity deleteProvenanceQuery(String provenanceQueryId) throws NiFiClientException, IOException {
        if (provenanceQueryId == null) {
            throw new IllegalArgumentException("Provenance Query ID cannot be null");
        }
        return this.executeAction("Error deleting Provenance Query", () -> {
            WebTarget target = this.provenanceTarget.path("/{id}").resolveTemplate("id", (Object)provenanceQueryId);
            return (ProvenanceEntity)this.getRequestBuilder(target).delete(ProvenanceEntity.class);
        });
    }

    @Override
    public LineageEntity submitLineageRequest(LineageEntity lineageEntity) throws NiFiClientException, IOException {
        if (lineageEntity == null) {
            throw new IllegalArgumentException("Lineage entity cannot be null");
        }
        return this.executeAction("Error submitting Provenance Lineage Request", () -> (LineageEntity)this.getRequestBuilder(this.provenanceTarget.path("lineage")).post(Entity.entity((Object)lineageEntity, (MediaType)MediaType.APPLICATION_JSON_TYPE), LineageEntity.class));
    }

    @Override
    public LineageEntity getLineageRequest(String lineageRequestId) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)lineageRequestId)) {
            throw new IllegalArgumentException("Lineage Request ID cannot be null");
        }
        return this.executeAction("Error retrieving status of Provenance Lineage Request", () -> {
            WebTarget target = this.provenanceTarget.path("/lineage/{id}").resolveTemplate("id", (Object)lineageRequestId);
            return (LineageEntity)this.getRequestBuilder(target).get(LineageEntity.class);
        });
    }

    @Override
    public LineageEntity deleteLineageRequest(String lineageRequestId) throws NiFiClientException, IOException {
        if (lineageRequestId == null) {
            throw new IllegalArgumentException("Lineage Request ID cannot be null");
        }
        return this.executeAction("Error deleting Provenance Lineage Request", () -> {
            WebTarget target = this.provenanceTarget.path("/lineage/{id}").resolveTemplate("id", (Object)lineageRequestId);
            return (LineageEntity)this.getRequestBuilder(target).delete(LineageEntity.class);
        });
    }

    @Override
    public ReplayLastEventResponseEntity replayLastEvent(String processorId, ProvenanceClient.ReplayEventNodes nodes) throws NiFiClientException, IOException {
        Objects.requireNonNull(processorId, "Processor ID required");
        Objects.requireNonNull(nodes, "Nodes must be specified");
        ReplayLastEventRequestEntity requestEntity = new ReplayLastEventRequestEntity();
        requestEntity.setComponentId(processorId);
        requestEntity.setNodes(nodes.name());
        return this.executeAction("Error replaying last event for Processor " + processorId, () -> {
            WebTarget target = this.provenanceEventsTarget.path("/latest/replays");
            return (ReplayLastEventResponseEntity)this.getRequestBuilder(target).post(Entity.entity((Object)requestEntity, (MediaType)MediaType.APPLICATION_JSON_TYPE), ReplayLastEventResponseEntity.class);
        });
    }

    @Override
    public LatestProvenanceEventsEntity getLatestEvents(String processorId) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)processorId)) {
            throw new IllegalArgumentException("Processor ID must be specified");
        }
        return this.executeAction("Error getting latest events for Processor " + processorId, () -> {
            WebTarget target = this.provenanceEventsTarget.path("/latest/").path(processorId);
            return (LatestProvenanceEventsEntity)this.getRequestBuilder(target).get(LatestProvenanceEventsEntity.class);
        });
    }

    @Override
    public InputStream getInputFlowFileContent(String provenanceEventId, String nodeId) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)provenanceEventId)) {
            throw new IllegalArgumentException("Provenance Event ID must be specified");
        }
        return this.executeAction("Error retrieving Input FlowFile Content from provenance event", () -> {
            WebTarget target = this.provenanceEventsTarget.path("/{id}/content/input").resolveTemplate("id", (Object)provenanceEventId);
            if (nodeId != null) {
                target = target.queryParam("clusterNodeId", new Object[]{nodeId});
            }
            return (InputStream)this.getRequestBuilder(target).get(InputStream.class);
        });
    }

    @Override
    public InputStream getOutputFlowFileContent(String provenanceEventId, String nodeId) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)provenanceEventId)) {
            throw new IllegalArgumentException("Provenance Event ID must be specified");
        }
        return this.executeAction("Error retrieving Output FlowFile Content from provenance event", () -> {
            WebTarget target = this.provenanceEventsTarget.path("/{id}/content/output").resolveTemplate("id", (Object)provenanceEventId);
            if (nodeId != null) {
                target = target.queryParam("clusterNodeId", new Object[]{nodeId});
            }
            return (InputStream)this.getRequestBuilder(target).get(InputStream.class);
        });
    }
}

