/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.manager;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.asteriskjava.manager.ManagerEventListener;
import org.asteriskjava.manager.event.ManagerEvent;
import org.asteriskjava.util.DaemonThreadFactory;

public class ManagerEventListenerProxy
implements ManagerEventListener {
    private final ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new DaemonThreadFactory());
    private final ManagerEventListener target;

    public ManagerEventListenerProxy(ManagerEventListener target) {
        this.target = target;
        if (target == null) {
            throw new NullPointerException("ManagerEventListener target is null!");
        }
    }

    @Override
    public void onManagerEvent(final ManagerEvent event) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                ManagerEventListenerProxy.this.target.onManagerEvent(event);
            }
        });
    }

    public void shutdown() {
        this.executor.shutdown();
    }

    public static class Access {
        private Access() {
        }

        public static int getThreadQueueSize(ManagerEventListenerProxy proxy) {
            return proxy.executor.getQueue().size();
        }
    }
}

