/*
 * Decompiled with CFR 0.152.
 */
package com.github.caldav4j.exceptions;

import com.github.caldav4j.exceptions.CalDAV4JException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;

public class BadStatusException
extends CalDAV4JException {
    private static final long serialVersionUID = 1L;
    private static final String MESSAGE = "Bad status %d invoking method %s %s";

    public BadStatusException(String message) {
        super(message);
    }

    public BadStatusException(String message, Throwable cause) {
        super(message, cause);
    }

    public BadStatusException(int status, String method, String path) {
        super(String.format(MESSAGE, status, method, path));
    }

    public <T extends HttpRequestBase> BadStatusException(T method, HttpResponse response) {
        super(String.format(MESSAGE, response.getStatusLine().getStatusCode(), method.getMethod(), method.getURI()));
    }
}

