/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.model.snapshots;

import io.prometheus.metrics.config.EscapingScheme;
import io.prometheus.metrics.model.snapshots.DataPointSnapshot;
import io.prometheus.metrics.model.snapshots.Labels;
import io.prometheus.metrics.model.snapshots.MetricMetadata;
import io.prometheus.metrics.model.snapshots.MetricSnapshot;
import io.prometheus.metrics.model.snapshots.SnapshotEscaper;
import io.prometheus.metrics.model.snapshots.Unit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;

public final class InfoSnapshot
extends MetricSnapshot {
    public InfoSnapshot(MetricMetadata metadata, Collection<InfoDataPointSnapshot> data) {
        this(metadata, data, false);
        if (metadata.hasUnit()) {
            throw new IllegalArgumentException("An Info metric cannot have a unit.");
        }
    }

    private InfoSnapshot(MetricMetadata metadata, Collection<InfoDataPointSnapshot> data, boolean internal) {
        super(metadata, data, internal);
    }

    public List<InfoDataPointSnapshot> getDataPoints() {
        return this.dataPoints;
    }

    @Override
    MetricSnapshot escape(EscapingScheme escapingScheme, List<? extends DataPointSnapshot> dataPointSnapshots) {
        return new InfoSnapshot(this.getMetadata().escape(escapingScheme), (Collection<InfoDataPointSnapshot>)dataPointSnapshots, true);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends MetricSnapshot.Builder<Builder> {
        private final List<InfoDataPointSnapshot> dataPoints = new ArrayList<InfoDataPointSnapshot>();

        private Builder() {
        }

        public Builder dataPoint(InfoDataPointSnapshot dataPoint) {
            this.dataPoints.add(dataPoint);
            return this;
        }

        @Override
        public Builder unit(@Nullable Unit unit) {
            throw new IllegalArgumentException("Info metric cannot have a unit.");
        }

        @Override
        public InfoSnapshot build() {
            return new InfoSnapshot(this.buildMetadata(), this.dataPoints);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }

    public static class InfoDataPointSnapshot
    extends DataPointSnapshot {
        public InfoDataPointSnapshot(Labels labels) {
            this(labels, 0L);
        }

        public InfoDataPointSnapshot(Labels labels, long scrapeTimestampMillis) {
            this(labels, scrapeTimestampMillis, false);
        }

        private InfoDataPointSnapshot(Labels labels, long scrapeTimestampMillis, boolean internal) {
            super(labels, 0L, scrapeTimestampMillis, internal);
        }

        public static Builder builder() {
            return new Builder();
        }

        @Override
        DataPointSnapshot escape(EscapingScheme escapingScheme) {
            return new InfoDataPointSnapshot(SnapshotEscaper.escapeLabels(this.getLabels(), escapingScheme), this.getScrapeTimestampMillis(), true);
        }

        public static class Builder
        extends DataPointSnapshot.Builder<Builder> {
            private Builder() {
            }

            public InfoDataPointSnapshot build() {
                return new InfoDataPointSnapshot(this.labels, this.scrapeTimestampMillis, true);
            }

            @Override
            protected Builder self() {
                return this;
            }
        }
    }
}

