/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.ldap.client.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.directory.api.ldap.model.constants.SaslQoP;
import org.apache.directory.api.ldap.model.constants.SaslSecurityStrength;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.util.Strings;
import org.apache.directory.ldap.client.api.SaslRequest;

public abstract class AbstractSaslRequest
implements SaslRequest {
    protected String saslMechanism;
    protected List<Control> controls = new ArrayList<Control>();
    protected String username;
    protected byte[] credentials;
    protected String realmName;
    protected String authorizationId;
    protected SaslQoP qualityOfProtection;
    protected SaslSecurityStrength securityStrength;
    protected boolean mutualAuthentication = false;

    protected AbstractSaslRequest(String saslMechanism) {
        this.saslMechanism = saslMechanism;
    }

    public void addAllControls(Control[] controls) {
        this.controls.addAll(Arrays.asList(controls));
    }

    public void addControl(Control control) {
        this.controls.add(control);
    }

    @Override
    public String getAuthorizationId() {
        return this.authorizationId;
    }

    @Override
    public Control[] getControls() {
        return this.controls.toArray(new Control[0]);
    }

    @Override
    public byte[] getCredentials() {
        if (this.credentials != null) {
            return this.credentials;
        }
        return Strings.EMPTY_BYTES;
    }

    @Override
    public SaslQoP getQualityOfProtection() {
        return this.qualityOfProtection;
    }

    @Override
    public String getRealmName() {
        return this.realmName;
    }

    @Override
    public String getSaslMechanism() {
        return this.saslMechanism;
    }

    @Override
    public SaslSecurityStrength getSecurityStrength() {
        return this.securityStrength;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public boolean isMutualAuthentication() {
        return this.mutualAuthentication;
    }

    public void setAuthorizationId(String authorizationId) {
        this.authorizationId = authorizationId;
    }

    public void setCredentials(byte[] credentials) {
        this.credentials = credentials;
    }

    public void setCredentials(String credentials) {
        this.credentials = Strings.getBytesUtf8(credentials);
    }

    public void setMutualAuthentication(boolean mutualAuthentication) {
        this.mutualAuthentication = mutualAuthentication;
    }

    public void setQualityOfProtection(SaslQoP qualityOfProtection) {
        this.qualityOfProtection = qualityOfProtection;
    }

    protected void setRealmName(String realmName) {
        this.realmName = realmName;
    }

    protected void setSaslMechanism(String saslMechanism) {
        this.saslMechanism = saslMechanism;
    }

    public void setSecurityStrength(SaslSecurityStrength securityStrength) {
        this.securityStrength = securityStrength;
    }

    public void setUsername(String username) {
        this.username = username;
    }
}

