/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.connection.tcp.TcpClientConnectionManager;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.instance.impl.DefaultOutOfMemoryHandler;
import com.hazelcast.internal.util.EmptyStatement;

public class ClientOutOfMemoryHandler
extends DefaultOutOfMemoryHandler {
    @Override
    public void onOutOfMemory(OutOfMemoryError oome, HazelcastInstance[] hazelcastInstances) {
        for (HazelcastInstance instance : hazelcastInstances) {
            if (!(instance instanceof HazelcastClientInstanceImpl)) continue;
            HazelcastClientInstanceImpl impl = (HazelcastClientInstanceImpl)instance;
            ClientHelper.cleanResources(impl);
        }
        try {
            oome.printStackTrace(System.err);
        }
        catch (Throwable ignored) {
            EmptyStatement.ignore(ignored);
        }
    }

    private static final class ClientHelper {
        private ClientHelper() {
        }

        static void cleanResources(HazelcastClientInstanceImpl client) {
            ClientHelper.closeSockets(client);
            ClientHelper.tryShutdown(client);
        }

        private static void closeSockets(HazelcastClientInstanceImpl client) {
            TcpClientConnectionManager connectionManager = (TcpClientConnectionManager)client.getConnectionManager();
            if (connectionManager != null) {
                try {
                    connectionManager.shutdown();
                }
                catch (Throwable ignored) {
                    EmptyStatement.ignore(ignored);
                }
            }
        }

        private static void tryShutdown(HazelcastClientInstanceImpl client) {
            try {
                client.doShutdown();
            }
            catch (Throwable ignored) {
                EmptyStatement.ignore(ignored);
            }
        }
    }
}

