/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.pipeline;

import com.hazelcast.jet.JetMemberSelector;
import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.impl.pipeline.AbstractStage;
import com.hazelcast.jet.impl.pipeline.BatchStageImpl;
import com.hazelcast.jet.impl.pipeline.ComputeStageImplBase;
import com.hazelcast.jet.impl.pipeline.Planner;
import com.hazelcast.jet.impl.pipeline.SinkImpl;
import com.hazelcast.jet.impl.pipeline.SinkStageImpl;
import com.hazelcast.jet.impl.pipeline.StreamSourceStageImpl;
import com.hazelcast.jet.impl.pipeline.transform.AbstractTransform;
import com.hazelcast.jet.impl.pipeline.transform.BatchSourceTransform;
import com.hazelcast.jet.impl.pipeline.transform.SinkTransform;
import com.hazelcast.jet.impl.pipeline.transform.StreamSourceTransform;
import com.hazelcast.jet.impl.pipeline.transform.Transform;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.pipeline.BatchSource;
import com.hazelcast.jet.pipeline.BatchStage;
import com.hazelcast.jet.pipeline.GeneralStage;
import com.hazelcast.jet.pipeline.Pipeline;
import com.hazelcast.jet.pipeline.Sink;
import com.hazelcast.jet.pipeline.SinkStage;
import com.hazelcast.jet.pipeline.StreamSource;
import com.hazelcast.jet.pipeline.StreamSourceStage;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;

public class PipelineImpl
implements Pipeline {
    private static final long serialVersionUID = 1L;
    private final Map<Transform, List<Transform>> adjacencyMap = new LinkedHashMap<Transform, List<Transform>>();
    private final Map<String, File> attachedFiles = new HashMap<String, File>();
    private boolean preserveOrder;
    private JetMemberSelector memberSelector;

    @Override
    @Nonnull
    public <T> BatchStage<T> readFrom(@Nonnull BatchSource<? extends T> source) {
        BatchSourceTransform xform = (BatchSourceTransform)source;
        xform.onAssignToStage();
        this.register(xform);
        return new BatchStageImpl(xform, this);
    }

    @Override
    @Nonnull
    public <T> StreamSourceStage<T> readFrom(@Nonnull StreamSource<? extends T> source) {
        StreamSourceTransform xform = (StreamSourceTransform)source;
        xform.onAssignToStage();
        this.register(xform);
        return new StreamSourceStageImpl(xform, this);
    }

    @Override
    public boolean isPreserveOrder() {
        return this.preserveOrder;
    }

    @Override
    @Nonnull
    public PipelineImpl setPreserveOrder(boolean value) {
        this.preserveOrder = value;
        return this;
    }

    public JetMemberSelector memberSelector() {
        return this.memberSelector;
    }

    public void setMemberSelector(JetMemberSelector memberSelector) {
        this.memberSelector = memberSelector;
    }

    @Override
    @Nonnull
    public <T> SinkStage writeTo(@Nonnull Sink<? super T> sink, @Nonnull GeneralStage<? extends T> stage0, @Nonnull GeneralStage<? extends T> stage1, GeneralStage<? extends T> ... moreStages) {
        ArrayList<GeneralStage<T>> stages = new ArrayList<GeneralStage<T>>(Arrays.asList(moreStages));
        stages.add(0, stage0);
        stages.add(1, stage1);
        List<Transform> upstream = stages.stream().map(s -> (AbstractStage)((Object)s)).map(s -> s.transform).collect(Collectors.toList());
        int[] ordinalsToAdapt = IntStream.range(0, stages.size()).filter(i -> ((ComputeStageImplBase)stages.get((int)i)).fnAdapter == ComputeStageImplBase.ADAPT_TO_JET_EVENT).toArray();
        SinkImpl sinkImpl = (SinkImpl)sink;
        SinkTransform sinkTransform = new SinkTransform(sinkImpl, upstream, ordinalsToAdapt);
        SinkStageImpl sinkStage = new SinkStageImpl(sinkTransform, this);
        sinkImpl.onAssignToStage();
        this.connectGeneralStages(stages, sinkTransform);
        return sinkStage;
    }

    @Nonnull
    public DAG toDag(Context context) {
        return new Planner(this).createDag(context);
    }

    @Override
    @Nonnull
    public DAG toDag() {
        int localParallelismUseDefault = -1;
        return this.toDag(new Context(){

            @Override
            public int defaultLocalParallelism() {
                return -1;
            }
        });
    }

    public void connect(@Nonnull List<ComputeStageImplBase> stages, @Nonnull AbstractTransform transform) {
        List<Transform> upstreamTransforms = transform.upstream();
        for (int i = 0; i < upstreamTransforms.size(); ++i) {
            ComputeStageImplBase us = stages.get(i);
            transform.setRebalanceInput(i, us.isRebalanceOutput);
            transform.setPartitionKeyFnForInput(i, us.rebalanceKeyFn);
        }
        upstreamTransforms.forEach(u -> this.adjacencyMap.get(u).add(transform));
        this.register(transform);
    }

    public void connect(@Nonnull ComputeStageImplBase stage, @Nonnull AbstractTransform toTransform) {
        this.connect(Collections.singletonList(stage), toTransform);
    }

    public void connect(@Nonnull ComputeStageImplBase stage0, @Nonnull List<? extends GeneralStage> moreStages, @Nonnull AbstractTransform toTransform) {
        List<ComputeStageImplBase> allStages = moreStages.stream().map(ComputeStageImplBase.class::cast).collect(Collectors.toList());
        allStages.add(0, stage0);
        this.connect(allStages, toTransform);
    }

    public void connectGeneralStages(@Nonnull List<? extends GeneralStage> stages, @Nonnull AbstractTransform toTransform) {
        List<ComputeStageImplBase> implStages = stages.stream().map(ComputeStageImplBase.class::cast).collect(Collectors.toList());
        this.connect(implStages, toTransform);
    }

    public void attachFiles(@Nonnull Map<String, File> filesToAttach) {
        this.attachedFiles.putAll(filesToAttach);
    }

    @Nonnull
    public Map<String, File> attachedFiles() {
        return Collections.unmodifiableMap(this.attachedFiles);
    }

    public String toString() {
        return "Pipeline " + this.adjacencyMap;
    }

    @Override
    @Nonnull
    public String toDotString() {
        this.makeNamesUnique();
        Map<Transform, List<Transform>> adjMap = this.adjacencyMap();
        HashMap<Transform, String> transformNames = new HashMap<Transform, String>();
        StringBuilder builder = new StringBuilder(256);
        builder.append("digraph Pipeline {\n");
        for (Map.Entry<Transform, List<Transform>> entry : adjMap.entrySet()) {
            Transform src = entry.getKey();
            String srcName = transformNames.computeIfAbsent(src, Transform::name);
            for (Transform dest : entry.getValue()) {
                String destName = transformNames.computeIfAbsent(dest, Transform::name);
                builder.append("\t").append("\"").append(Util.escapeGraphviz(srcName)).append("\"").append(" -> ").append("\"").append(Util.escapeGraphviz(destName)).append("\"").append(";\n");
            }
        }
        builder.append("}");
        return builder.toString();
    }

    @Override
    public boolean isEmpty() {
        return this.adjacencyMap.isEmpty();
    }

    Map<Transform, List<Transform>> adjacencyMap() {
        LinkedHashMap<Transform, List<Transform>> safeCopy = new LinkedHashMap<Transform, List<Transform>>();
        this.adjacencyMap.forEach((k, v) -> safeCopy.put((Transform)k, new ArrayList(v)));
        return safeCopy;
    }

    void makeNamesUnique() {
        HashSet<String> usedNames = new HashSet<String>();
        for (Transform transform : this.adjacencyMap.keySet()) {
            while (!usedNames.add(transform.name())) {
                transform.setName(Util.addOrIncrementIndexInName(transform.name()));
            }
        }
    }

    private void register(Transform stage) {
        List prev = this.adjacencyMap.putIfAbsent(stage, new ArrayList());
        assert (prev == null) : "Double registration of a Stage with this Pipeline: " + stage;
    }

    public static interface Context {
        public int defaultLocalParallelism();
    }
}

