/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.map.impl.operation.steps.engine.State;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.operationservice.PartitionAwareOperation;
import java.io.IOException;

public abstract class KeyBasedMapOperation
extends MapOperation
implements PartitionAwareOperation {
    protected long threadId;
    protected Data dataKey;
    protected Data dataValue;

    public KeyBasedMapOperation() {
    }

    public KeyBasedMapOperation(String name, Data dataKey) {
        super(name);
        this.dataKey = dataKey;
    }

    protected KeyBasedMapOperation(String name, Data dataKey, Data dataValue) {
        super(name);
        this.dataKey = dataKey;
        this.dataValue = dataValue;
    }

    @Override
    public State createState() {
        return super.createState().setKey(this.dataKey).setNewValue(this.dataValue).setThreadId(this.threadId);
    }

    public final Data getKey() {
        return this.dataKey;
    }

    @Override
    public final long getThreadId() {
        return this.threadId;
    }

    @Override
    public final void setThreadId(long threadId) {
        this.threadId = threadId;
    }

    public final Data getValue() {
        return this.dataValue;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        IOUtil.writeData(out, this.dataKey);
        IOUtil.writeData(out, this.dataValue);
        out.writeLong(this.threadId);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.dataKey = IOUtil.readData(in);
        this.dataValue = IOUtil.readData(in);
        this.threadId = in.readLong();
    }
}

