/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.vector;

import com.hazelcast.spi.annotation.Beta;
import com.hazelcast.vector.Hint;
import com.hazelcast.vector.SearchOptions;
import com.hazelcast.vector.impl.SearchOptionsImpl;
import java.util.HashMap;
import java.util.Map;

@Beta
public class SearchOptionsBuilder {
    private static final int DEFAULT_SEARCH_LIMIT = 10;
    private boolean includeValue;
    private boolean includeVectors;
    private int limit = 10;
    private Map<String, String> hints;

    public SearchOptionsBuilder includeValue() {
        this.includeValue = true;
        return this;
    }

    public SearchOptionsBuilder setIncludeValue(boolean includeValue) {
        this.includeValue = includeValue;
        return this;
    }

    public SearchOptionsBuilder includeVectors() {
        this.includeVectors = true;
        return this;
    }

    public SearchOptionsBuilder setIncludeVectors(boolean includeVectors) {
        this.includeVectors = includeVectors;
        return this;
    }

    public SearchOptionsBuilder limit(int limit) {
        if (limit <= 0) {
            throw new IllegalArgumentException("Limit must be positive");
        }
        this.limit = limit;
        return this;
    }

    public <T> SearchOptionsBuilder hint(String hintName, T value) {
        if (this.hints == null) {
            this.hints = new HashMap<String, String>();
        }
        this.hints.put(hintName, value.toString());
        return this;
    }

    public <T> SearchOptionsBuilder hint(Hint<T> hint, T value) {
        if (this.hints == null) {
            this.hints = new HashMap<String, String>();
        }
        this.hints.put(hint.name(), value.toString());
        return this;
    }

    public SearchOptionsBuilder hints(Map<String, String> hints) {
        if (this.hints == null) {
            this.hints = new HashMap<String, String>();
        }
        this.hints.putAll(hints);
        return this;
    }

    public SearchOptions build() {
        return new SearchOptionsImpl(this.includeValue, this.includeVectors, this.limit, this.hints);
    }
}

