/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.admin.rooms;

import jakarta.inject.Inject;
import java.io.Serializable;
import org.apache.openmeetings.db.dao.room.RoomDao;
import org.apache.openmeetings.db.entity.room.Room;
import org.apache.openmeetings.web.admin.AdminBasePanel;
import org.apache.openmeetings.web.admin.SearchableDataView;
import org.apache.openmeetings.web.admin.rooms.RoomForm;
import org.apache.openmeetings.web.common.PagedEntityListPanel;
import org.apache.openmeetings.web.data.DataViewContainer;
import org.apache.openmeetings.web.data.OmOrderByBorder;
import org.apache.openmeetings.web.data.SearchableGroupAdminDataProvider;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authroles.authorization.strategies.role.annotations.AuthorizeInstantiation;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.danekja.java.util.function.serializable.SerializableConsumer;

@AuthorizeInstantiation(value={"ADMIN", "GROUP_ADMIN"})
public class RoomsPanel
extends AdminBasePanel {
    private static final long serialVersionUID = 1L;
    final WebMarkupContainer listContainer = new WebMarkupContainer("listContainer");
    private RoomForm form;
    @Inject
    private RoomDao roomDao;

    public RoomsPanel(String id) {
        super(id);
        SearchableDataView<Room> dataView = new SearchableDataView<Room>("roomList", new SearchableGroupAdminDataProvider(RoomDao.class)){
            private static final long serialVersionUID = 1L;

            protected void populateItem(Item<Room> item) {
                Room room = (Room)item.getModelObject();
                Long roomId = room.getId();
                item.add(new Component[]{new Label("id")});
                item.add(new Component[]{new Label("name")});
                item.add(new Component[]{new Label("ispublic")});
                item.add(new Behavior[]{AjaxEventBehavior.onEvent((String)"click", (SerializableConsumer & Serializable)target -> {
                    RoomsPanel.this.form.setNewRecordVisible(false);
                    RoomsPanel.this.form.setModelObject(RoomsPanel.this.roomDao.get(roomId));
                    RoomsPanel.this.form.updateView((AjaxRequestTarget)target);
                    target.add(new Component[]{RoomsPanel.this.form, RoomsPanel.this.listContainer});
                })});
                item.add(new Behavior[]{AttributeModifier.replace((String)"class", (Serializable)RoomsPanel.this.getRowClass(room.getId(), ((Room)RoomsPanel.this.form.getModelObject()).getId()))});
            }
        };
        this.add(new Component[]{this.listContainer.add(new Component[]{dataView}).setOutputMarkupId(true)});
        PagedEntityListPanel navigator = new PagedEntityListPanel("navigator", dataView){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onEvent(AjaxRequestTarget target) {
                target.add(new Component[]{RoomsPanel.this.listContainer});
            }
        };
        DataViewContainer<Room> container = new DataViewContainer<Room>(this.listContainer, dataView, navigator);
        container.addLink(new OmOrderByBorder<Room>("orderById", "id", container)).addLink(new OmOrderByBorder<Room>("orderByName", "name", container)).addLink(new OmOrderByBorder<Room>("orderByPublic", "ispublic", container));
        this.add((Component[])container.getLinks());
        this.add(new Component[]{navigator});
        Component[] componentArray = new Component[1];
        this.form = new RoomForm("form", this.listContainer, null);
        componentArray[0] = this.form;
        this.add(componentArray);
    }
}

