/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.user.chat;

import org.apache.openmeetings.db.entity.room.Room;
import org.apache.openmeetings.web.user.chat.Chat;
import org.apache.wicket.Component;
import org.apache.wicket.authroles.authorization.strategies.role.annotations.AuthorizeInstantiation;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.panel.Panel;

@AuthorizeInstantiation(value={"DASHBOARD", "ROOM"})
public class ChatPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    private final Chat chat;

    public ChatPanel(String id) {
        super(id);
        this.setOutputMarkupPlaceholderTag(true);
        this.setMarkupId(id);
        Component[] componentArray = new Component[1];
        this.chat = new Chat("chat");
        componentArray[0] = this.chat;
        this.add(componentArray);
    }

    public void roomEnter(Room r, IPartialPageRequestHandler handler) {
        if (r.isHidden(Room.RoomElement.CHAT)) {
            this.toggle(handler, false);
            return;
        }
        StringBuilder sb = new StringBuilder("$(function() {");
        if (!this.chat.isShowDashboardChat()) {
            sb.append("$('#chatPanel').show();");
        }
        sb.append("Chat.setRoomMode(true);").append(this.chat.addRoom(r)).append("Chat.").append(r.isChatOpened() ? "setOpened" : "close").append("();");
        this.chat.processGlobal(sb);
        sb.append("});");
        handler.appendJavaScript((CharSequence)sb);
    }

    public void roomExit(Room r, IPartialPageRequestHandler handler) {
        if (r.isHidden(Room.RoomElement.CHAT)) {
            return;
        }
        handler.appendJavaScript((CharSequence)String.format("if (typeof(Chat) === 'object') { Chat.removeTab('%1$s%2$d'); }", "chatTab-r", r.getId()));
        StringBuilder sb = new StringBuilder("$(function() {").append("Chat.setRoomMode(false);");
        if (!this.chat.isShowDashboardChat()) {
            sb.append("$('#chatPanel').hide();");
        }
        sb.append("});");
        handler.appendJavaScript((CharSequence)sb);
    }

    public void toggle(IPartialPageRequestHandler handler, boolean visible) {
        this.setVisible(visible);
        if (handler != null) {
            handler.add(new Component[]{this});
            if (visible) {
                handler.appendJavaScript(this.chat.getReinit());
            }
        }
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        if (!this.chat.isShowDashboardChat()) {
            response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)"$('#chatPanel').hide();"));
        }
    }
}

