/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.util;

import com.github.openjson.JSONObject;
import org.apache.openmeetings.db.entity.basic.Client;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.wicket.protocol.http.ClientProperties;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.util.string.Strings;

public class ExtendedClientProperties
extends ClientProperties {
    private static final long serialVersionUID = 1L;
    public static final String CAM = "cam";
    public static final String MIC = "mic";
    public static final String WIDTH = "width";
    public static final String HEIGHT = "height";
    private String baseUrl;
    private String codebase;
    private String settings;

    public String getCodebase() {
        return this.codebase;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public ExtendedClientProperties setSettings(JSONObject s) {
        this.settings = s.toString();
        return this;
    }

    public JSONObject getSettings() {
        try {
            return Strings.isEmpty((String)this.settings) ? new JSONObject() : new JSONObject(this.settings);
        }
        catch (Exception exception) {
            return new JSONObject();
        }
    }

    private static StringBuilder cleanUrl(String inUrl) {
        StringBuilder sb = new StringBuilder();
        String url = inUrl;
        int semi = url.indexOf(59);
        if (semi > -1) {
            url = url.substring(0, semi);
        }
        for (String tail : new String[]{"/hash", "/signin", "/notinited"}) {
            if (!url.endsWith(tail)) continue;
            url = url.substring(0, url.length() - tail.length());
            break;
        }
        return sb.append(url);
    }

    public void read(IRequestParameters parameters) {
        super.read(parameters);
        String url = parameters.getParameterValue("codebase").toString(OpenmeetingsVariables.getBaseUrl());
        StringBuilder sb = ExtendedClientProperties.cleanUrl(url);
        if (sb.charAt(sb.length() - 1) != '/') {
            sb.append('/');
        }
        this.baseUrl = sb.toString();
        this.codebase = sb.append("screenshare").toString();
        this.settings = parameters.getParameterValue("settings").toString("{}");
    }

    public Client update(Client c) {
        JSONObject s = this.getSettings().optJSONObject("video");
        if (s == null) {
            s = new JSONObject();
        }
        return c.setRemoteAddress(this.getRemoteAddress()).setCam(s.optInt(CAM, -1)).setMic(s.optInt(MIC, -1)).setWidth(s.optInt(WIDTH, 0)).setHeight(s.optInt(HEIGHT, 0));
    }
}

